; TDFHeaders.inc


; ===================================================================



BGLHeader	Macro	NorthB, SouthB, EastB, WestB, LWM_Header, VTP_Header

; if LWMStart = TerrainHeaderStart then LWM polygon header disabled
; if VTPStart = TerrainHeaderStart then VTP polygon/line header disabled
; NorthB, SouthB, EastB, WestB, are the Bounds in whole integer degrees
; Make the bounds generous by giving an extra degree to the area

NorthBounds 	EQU 	( ( NorthB * 1111305 ) / 10 )
SouthBounds	EQU	( ( SouthB * 1111305 ) / 10 )
EastBounds	EQU	EastB * 11930465
WestBounds	EQU	WestB * 11930465

BGLHeaderStart	label	word

	dw	1		; world set number
	dd	NorthBounds
	dd	SouthBounds
	dd	EastBounds
	dd	WestBounds
	dd	0		; VOR data
	dw	0		; lowest VOR freq
	dw	0		; highest VOR freq
	dd	0		; seeds level 8 data
	dd	0		; seeds level 9 data
	dd	0		; seeds level 10 data
	dd	0		; seeds level 11 data
	dd	0		; seeds level 12 data
	dd	0		; traffic data
	dd	0		; minimum safe altitude data
	dd	TerrainHeaderStart - BGLHeaderStart	; terrain mesh data
	dd	0		; object data
	dd	0		; library data
	dd	0		; facilities data
	dd	0		; anchor point data
	dd	0		; ATIS data
	dd	0		; NDB data
	dd	0		; dynamic object paths data
	dd	0h,0h		; minimum library id
	dd	0h,0h		; maximum library id
	dd	0		; miscellaneous data
	dd	0		; title and description data
	dd	0		; magnetic variation data
	dd	0		; exception and exclusion data
	dd	87654321h		; magic number
	dd	0		; compression switch
	dw	0		; spare
	dd	0h,0h,0h,0h		; GUID
	dd	0		; product id
	dd	0		; product build number
	dd	0		; new facility data pointers
	dd	0		; new facility name list data
	dd	0		; new facility band list data
	dd	0		; new facility data

; ===================================================================

; TERRAIN_Header

TerrainHeaderStart	label	word

	dd	TerrainHeaderEnd - TerrainHeaderStart	; end of terrain header
	dd	514		; version
	dd	0		; unknown entry
	dd	0		; unknown entry
	dd	0		; elevation header
	dd	0		; land class header
	dd	0		; unknown header
	dd	0		; class lookup header
	dd	0		; season header
	dd	0		; class lookup list
	dd	0		; water class header
	dd	0		; elevation index
	dd	0		; land cover index
	dd	0		; unknown index

	dd	LWM_Header - TerrainHeaderStart		; LWM polygon header
							; LWM_Header must be the ID label of the LWM_Header
	dd	VTP_Header - TerrainHeaderStart		; VTP polygon/line header
							; VTP_Header must be the ID label of the VTP_Header
	dd	0		; reserved
	dd	0		; reserved
	dd	0		; main terrain data
	dd	0		; reserved
	dd	0		; reserved
	dd	0		; reserved
	dd	0		; regions header
	dd	0		; reserved
	dd	0		; reserved

TerrainHeaderEnd	label	word

; ===================================================================

EndM
