﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using NaGet.Tasks;
using NaGet.Packages;
using NaGet.Packages.Install;

namespace NaGet.SubCommands.SubTask
{
	public class VerifyInstallerFileSubTask : NaGetSubTask
	{
		IList<Installation> installations = null;
		
		IList<Installation> invalidInstallers = null;
		
		public VerifyInstallerFileSubTask(IList<Installation> insts)
		{
			installations = new ReadOnlyCollection<Installation>(insts);
		}
		
		public IList<Installation> InvalidInstallers {
			get { return invalidInstallers; }
		}
		
		public override void Run()
		{
			NotifyStarted();
			
			List<Installation> invalidInstallers = new List<Installation>();
			
			for (int i = 0; i < installations.Count; i++) {
				Installation inst = installations[i];
				float percent = 100.0f * i / installations.Count;
				
				if (inst.GetRegisteredHashCount() > 0) {
					if (inst.IsInstallablePackage() && inst.VerifyHashValues() == false) {
						invalidInstallers.Add(inst);
						RaiseTaskSetEvent(TaskEventType.WARNING, "検証: "+inst.ToString() + " 非整合", percent);
					} else {
						RaiseTaskSetEvent(TaskEventType.INFO, "検証: "+inst.ToString() + " OK", percent);
					}
				} else {
					RaiseTaskSetEvent(TaskEventType.PING, string.Empty, percent);
				}
			}
			
			if (invalidInstallers.Count > 0) {
				this.invalidInstallers = invalidInstallers.AsReadOnly();
			} else {
				this.invalidInstallers = null;
			}
			
			NotifyCompleted();
		}
	}
}
