using System;

namespace AllGet
{
	
	sealed class Util
	{
		public static char Query(string msg, string selections, char defaultSelection)
		{
			int resNum = -1;
			while (resNum < 0) {	
				Console.Write(msg);
				string response = Console.ReadLine();
				response = response.Trim().ToLower();
				if (response.Length < 1) return defaultSelection;
				resNum = selections.ToLower().IndexOf(response[0]);
			}
			return selections[resNum];
		}
		
		public static bool Confirm(string msg, bool defaultSelection)
		{
			return Query(msg, "yn", defaultSelection? 'y' : 'n') == 'y';
		}
	}
}
