﻿using System;
using System.IO;
using System.Collections.Generic;
using System.Xml.Serialization;
using System.ComponentModel;

namespace NaGet
{
	/// <summary>
	/// na-get-libの全般設定クラス
	/// </summary>
	[XmlRoot("Pref")]
	public class NaGetLibPref
	{
		/// <summary>
		/// アプリケーションデータを置くフォルダー。
		/// </summary>
		/// <remarks>デフォルトではカレントディレクトリ</remarks>
		[XmlElement]
		[DefaultValue(null)]
		public string AppDataFolder = null;
		
		/// <summary>
		/// キャッシュを置くフォルダー。
		/// </summary>
		/// <remarks>デフォルトではAppDataFolderの中のCacheフォルダ</remarks>
		[XmlElement]
		[DefaultValue(null)]
		public string CacheFolder = null;
		
		/// <summary>
		/// ネットワークアクセスに使うプロキシをURL形式で指定する。
		/// </summary>
		/// <remarks>デフォルトではシステムの設定を使用する</remarks>
		[XmlElement]
		public string ProxyAddress = null;
		
		/// <summary>
		/// ウイルススキャンをする。
		/// </summary>
		[XmlElement]
		[DefaultValue(true)]
		public bool EnableScanInstallerFile = true;
		
		/// <summary>
		/// インストールをバックグラウンドで実行する。
		/// </summary>
		[XmlElement]
		[DefaultValue(true)]
		public bool InstallOnBackground = true;
		
		/// <summary>
		/// アップデートから除外するパッケージ名
		/// </summary>
		[XmlElement("ExcludeUpdatePackageName")]
		[DefaultValue(null)]
		public string[] ExcludeUpdatePackageNames = null;
	}
}
