﻿using System;
using System.IO;

namespace NaGet
{
	/// <summary>
	/// 環境変数などを取り扱うクラス
	/// </summary>
	public sealed class Env
	{
		/// <summary>
		/// 呼び出し禁止
		/// </summary>
		private Env()
		{
		}

		
		/// <summary>		
		/// ファイルリスト提供サーバのリストファイル	
		/// </summary>
		public static readonly string ProviderListFile = "provider.list.txt";

		/// <summary>
		/// ファイルリストから読み込まれたパッケージのリストファイル
		/// </summary>
		public static readonly string PackageListFile = "packages.list.xml";

		/// <summary>
		/// 本ソフトウェアを介してインストールされたパッケージのリストファイル
		/// </summary>
		public static readonly string ArchiveInstalledPackageListFile = "packages.envinstalled.xml";

		/// <summary>
		/// システムから検出されたパッケージのリストファイル
		/// </summary>
		public static readonly string SystemInstalledPackageListFile = "packages.sysinstalled.xml";
		
		/// <summary>
		/// インストールログファイル
		/// </summary>
		public static readonly string SystemInstalledPackageLogFile = "packages.sysinstalled.log.xml";
		
		private static string appDataFolderPath = null;
		
		/// <summary>
		/// アプリケーションデータを保存するフォルダのパス
		/// </summary>
		public static string AppDataFolderPath
		{
			get {
				if (appDataFolderPath == null) {
//					string progFiles = Environment.GetFolderPath(Environment.SpecialFolder.ProgramFiles);
//					if (Path.GetDirectoryName(Environment.CurrentDirectory) == progFiles) {
//						string appData = Environment.GetFolderPath(Environment.SpecialFolder.LocalApplicationData);
//						return Path.Combine(appData, "AppliStation");
//					} else {
						return Environment.CurrentDirectory;
//					}
				} else {
					return appDataFolderPath;
				}
			}
			set { appDataFolderPath = value; }
		}

		/// <summary>
		/// インストーラの一時置き場の親ディレクトリ
		/// </summary>
		public static string ArchiveFolderPath
		{
			get { return Path.Combine(AppDataFolderPath, "Cache"); }
		}
		
		/// <summary>
		/// アーカイバ方式のパッケージのインストール先フォルダ
		/// </summary>
		public static string ArchiveProgramFiles {
			get {
				return Path.Combine(AppDataFolderPath, "progs");
			}
		}
		
		/// <summary>
		/// アーカイバ方式のパッケージのプログラムグループフォルダ
		/// </summary>
		public static string ArchiveProgramGroup {
			get {
				return Path.Combine(AppDataFolderPath, "programs");
			}
		}

		/// <summary>
		/// アーカイバ方式のパッケージのSystem32のフォルダ
		/// </summary>
		public static string ArchiveSystem32 {
			get {
				return Path.Combine(ArchiveProgramFiles, ".system32");
			}
		}
	}
}
