using System;
using System.IO;
using System.Runtime.InteropServices;

namespace NaGet.InteropServices
{	
	public sealed class PEFileInfoUtils
	{
		// Ăяo֎~
		private PEFileInfoUtils()
		{
		}
		
		/// <summary>
		/// PEt@C̎
		/// </summary>
		public enum PEFileType : uint
		{
			/// <summary>
			/// sȌ`A邢PEt@Cwb_Ȃ
			/// </summary>
			Unknown = 0,
			/// <summary>
			/// WindowsR\[AvP[V
			/// </summary>
			WinConsole = 1,
			/// <summary>
			/// Windows GUIAvP[V
			/// </summary>
			WinGUI = 2,
			/// <summary>
			/// MS-DOS(yуR}hvvg)łCOMt@C
			/// </summary>
			MSDosCom = 3,
		}
		
		/// <summary>
		/// nꂽst@C̎ނԂBSHGetFileInfogpB
		/// </summary>
		/// <param name="path">st@C(*.exe,*.dll)ւ̃pX</param>
		/// <returns>st@C̎</returns>
		public static PEFileType GetPEFileType(string path)
		{
			PEFileType fileType;
			
			try {
				SHFILEINFO info = new SHFILEINFO();
				int type = (int) shGetFileInfo(path, 0, ref info, SHGFI.ExeType);
				
				const int MZ = 0x5a4d;
				const int NE = 0x504e;
				const int PE = 0x4550;
				switch (type)
				{
					case MZ:
						fileType = PEFileType.MSDosCom;
						break;
					case PE:
						fileType = PEFileType.WinConsole;
						break;
					default:
						int loWord = type & 0xffff;
						int hiWord = (type >> 16) & 0xffff;
						
						if (((loWord == PE) || (loWord == NE)) &&
						    ((hiWord == 0x0300) || (hiWord == 0x0350) || (hiWord == 0x0400)))
						{
							fileType = PEFileType.WinGUI;
						} else {
							fileType = PEFileType.Unknown;
						}
						break;
				}
			} catch (FileNotFoundException e) {
				throw new FileNotFoundException(e.Message, e);
			} catch (IOException) {
				fileType = PEFileType.Unknown;
			}
			
			return fileType;
		}
		
		#region SHGetFileInfo
		
		[StructLayout(LayoutKind.Sequential, CharSet=CharSet.Auto)]
		private struct SHFILEINFO
		{
			public IntPtr hIcon;
			public IntPtr iIcon;
			public uint dwAttributes;
			[MarshalAs(UnmanagedType.ByValTStr, SizeConst=260)]
			public string szDisplayName;
			[MarshalAs(UnmanagedType.ByValTStr, SizeConst=80)]
			public string szTypeName;
		}
		
		private enum SHGFI : uint
		{
			Icon = 256,
			DisplayName = 512,
			TypeName = 1024,
			Attributes = 2048,
			IconLocation = 4096,
			ExeType = 8192,
			SysIconIndex = 16384,
			LinkOverlay = 32768,
			Selected = 65536,
			AttrSpecified = 131072,
			LargeIcon = 0,
			SmallIcon = 1,
			OpenIcon = 2,
			PIDL = 8,
			UseFileAttributes = 16
		}
		
		[DllImport("shell32.dll", CharSet=CharSet.Auto)]
		private static extern IntPtr SHGetFileInfo(string pszPath, uint dwFileAttributes, ref SHFILEINFO psfi, uint cbFileInfo, uint uFlags);

		/// <summary>
		/// SHGetFileInfoĂяo֗\bhBt@Cǂݍ݂ȂǂɎsA
		/// st@CłȂꍇIOException𓊂܂B
		/// </summary>
		/// <param name="pszPath">t@CpX</param>
		/// <param name="dwFileAttributes">t@C</param>
		/// <param name="psfi">t@C</param>
		/// <param name="uFlags">tO</param>
		private static IntPtr shGetFileInfo(string pszPath, uint dwFileAttributes, ref SHFILEINFO psfi, SHGFI uFlags)
		{
			if (! File.Exists(pszPath)) {
				throw new FileNotFoundException(null, pszPath);
			}
			
			IntPtr hSuccess = SHGetFileInfo(pszPath, 0, ref psfi, (uint)Marshal.SizeOf(psfi), (uint) uFlags);
			if (hSuccess == IntPtr.Zero) {
				throw new IOException(string.Format("Maybe {0} is not a executable file.", pszPath));
			}
			return hSuccess;
		}
		
		#endregion
	}
}
