using System;
using System.ComponentModel;
using System.Drawing;
using System.Windows.Forms;

using NaGet.Packages;
using NaGet.Packages.Install;
using System.Reflection;

namespace AppliStation
{
	/// <summary>
	/// Description of InstallerInfoForm.
	/// </summary>
	public partial class InstallerInfoForm : UserControl
	{
		private Installer inst;
		
		public InstallerInfoForm()
		{
			//
			// The InitializeComponent() call is required for Windows Forms designer support.
			//
			InitializeComponent();
		}
		
		public Installer SelectedObject {
			get { return inst; }
			set {
				inst = value;
				updateInst();
			}
		}
		
		private void updateInst()
		{
			installerUrlTextBox.Text = (inst == null || inst.Url == null)?
				string.Empty : inst.Url.Href;
			
			if (inst.Platform == null || string.IsNullOrEmpty(inst.Platform.Os)) {
				osValueLabel.Text = "CӂWindows";
			} else {
				osValueLabel.Text = inst.Platform.Os.Replace("WIN", string.Empty);
			}
			
			switch ((inst.Platform != null)? inst.Platform.Arch : System.Reflection.ProcessorArchitecture.X86) {
				case System.Reflection.ProcessorArchitecture.Amd64:
					archValueLabel.Text = "x64 (64rbg)";
					break;
				case System.Reflection.ProcessorArchitecture.IA64:
					archValueLabel.Text = "Itanium";
					break;
				case System.Reflection.ProcessorArchitecture.None:
				case System.Reflection.ProcessorArchitecture.MSIL:
					archValueLabel.Text = "A[LeN`ˑȂ";
					break;
				case System.Reflection.ProcessorArchitecture.X86:
					archValueLabel.Text = "x86 (32rbg)";
					break;
			}
			
			cannotRunLabel.Visible = ! ((inst.Platform == null) || inst.Platform.IsRunnable());
		}
	}
}
