/*
 * Decompiled with CFR 0.152.
 */
package net.osdn.util.yaml;

import com.esotericsoftware.yamlbeans.YamlReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import net.osdn.util.yaml.CharsetDetector;

public class Yaml {
    private static Charset UTF_8 = Charset.forName("UTF-8");
    private Object root;
    private Map<String, Object> map;
    private List<Object> list;
    private String trailer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Yaml(File file) throws IOException {
        if (file == null) {
            throw new NullPointerException();
        }
        Charset charset = CharsetDetector.detectCharset(file);
        if (charset == null) {
            charset = UTF_8;
        }
        StringBuilder header = new StringBuilder();
        StringBuilder trailer = null;
        try (BufferedReader reader = null;){
            String line;
            boolean isFirst = true;
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), charset));
            while ((line = reader.readLine()) != null) {
                if (isFirst) {
                    if (charset.equals(UTF_8) && line.length() > 0 && line.charAt(0) == '\ufeff') {
                        line = line.substring(1);
                    }
                    isFirst = false;
                }
                if (trailer != null || header.length() != 0 || line.length() <= 0 || line.charAt(0) == '\ufeff') {
                    // empty if block
                }
                if (trailer == null && line.startsWith("...") && (line.length() == 3 || line.substring(3).trim().length() == 0)) {
                    trailer = new StringBuilder();
                    continue;
                }
                if (trailer == null) {
                    header.append(line);
                    header.append('\n');
                    continue;
                }
                trailer.append(line);
                trailer.append('\n');
            }
            this.root = new YamlReader(header.toString()).read();
            if (this.root instanceof Map) {
                Map map;
                this.map = map = (Map)this.root;
            } else if (this.root instanceof List) {
                List list;
                this.list = list = (List)this.root;
            }
            if (trailer != null) {
                this.trailer = trailer.toString();
            }
        }
    }

    public boolean containsKey(String key) {
        return this.map.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    public Object get(String key) {
        return this.map.get(key);
    }

    public String getTrailer() {
        return this.trailer;
    }

    public Object getRoot() {
        return this.root;
    }

    public Map<String, Object> getMap() {
        return this.map;
    }

    public List<Object> getList() {
        return this.list;
    }
}

