/*
 * Decompiled with CFR 0.152.
 */
package net.osdn.util.yaml;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.mozilla.universalchardet.UniversalDetector;

public class CharsetDetector {
    private static Charset UTF_8 = Charset.forName("UTF-8");
    private static UniversalDetector detector = new UniversalDetector(null);
    private static byte[] buf = new byte[8192];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized Charset detectCharset(File file) throws IOException {
        if (file == null) {
            throw new NullPointerException();
        }
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            Charset charset = CharsetDetector.detectCharset(in);
            return charset;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized Charset detectCharset(InputStream in) throws IOException {
        if (in == null) {
            throw new NullPointerException();
        }
        try {
            int size;
            while ((size = in.read(buf)) > 0 && !detector.isDone()) {
                detector.handleData(buf, 0, size);
            }
            detector.dataEnd();
            String charset = detector.getDetectedCharset();
            if (charset != null) {
                Charset charset2 = Charset.forName(charset);
                return charset2;
            }
            Charset charset3 = null;
            return charset3;
        }
        finally {
            detector.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> readAllLines(File file) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        Charset charset = CharsetDetector.detectCharset(file);
        if (charset == null) {
            charset = UTF_8;
        }
        try (BufferedReader reader = null;){
            String line;
            boolean isFirst = true;
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), charset));
            while ((line = reader.readLine()) != null) {
                if (isFirst) {
                    if (charset.equals(UTF_8) && line.length() > 0 && line.charAt(0) == '\ufeff') {
                        line = line.substring(1);
                    }
                    isFirst = false;
                }
                lines.add(line);
            }
        }
        return lines;
    }
}

