/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.amateras.mirage.util;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class IOUtil {
    public static byte[] readStream(InputStream in) {
        if (in == null) {
            return null;
        }
        ByteArrayOutputStream out = null;
        try {
            out = new ByteArrayOutputStream();
            byte[] buf = new byte[8192];
            int length = 0;
            while ((length = in.read(buf)) != -1) {
                out.write(buf, 0, length);
            }
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            IOUtil.closeQuietly(in);
            IOUtil.closeQuietly(out);
        }
    }

    public static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static Properties loadProperties(String path) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        InputStream in = null;
        try {
            in = cl.getResourceAsStream(path);
            Properties properties = new Properties();
            properties.load(in);
            Properties properties2 = properties;
            return properties2;
        }
        catch (Exception ex) {
            return null;
        }
        finally {
            IOUtil.closeQuietly(in);
        }
    }
}

