/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.amateras.mirage.type;

import java.io.ByteArrayInputStream;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import jp.sf.amateras.mirage.type.ValueType;
import jp.sf.amateras.mirage.util.IOUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultValueType
implements ValueType {
    private static final int TYPE_UNKNOWN = Integer.MIN_VALUE;
    private static Map<Class<?>, Integer> javaTypeToSqlTypeMap = new HashMap(32);

    static {
        javaTypeToSqlTypeMap.put(Byte.TYPE, new Integer(-6));
        javaTypeToSqlTypeMap.put(Byte.class, new Integer(-6));
        javaTypeToSqlTypeMap.put(Short.TYPE, new Integer(5));
        javaTypeToSqlTypeMap.put(Short.class, new Integer(5));
        javaTypeToSqlTypeMap.put(Integer.TYPE, new Integer(4));
        javaTypeToSqlTypeMap.put(Integer.class, new Integer(4));
        javaTypeToSqlTypeMap.put(Long.TYPE, new Integer(-5));
        javaTypeToSqlTypeMap.put(Long.class, new Integer(-5));
        javaTypeToSqlTypeMap.put(BigInteger.class, new Integer(-5));
        javaTypeToSqlTypeMap.put(Float.TYPE, new Integer(6));
        javaTypeToSqlTypeMap.put(Float.class, new Integer(6));
        javaTypeToSqlTypeMap.put(Double.TYPE, new Integer(8));
        javaTypeToSqlTypeMap.put(Double.class, new Integer(8));
        javaTypeToSqlTypeMap.put(BigDecimal.class, new Integer(3));
        javaTypeToSqlTypeMap.put(Date.class, new Integer(91));
        javaTypeToSqlTypeMap.put(Time.class, new Integer(92));
        javaTypeToSqlTypeMap.put(Timestamp.class, new Integer(93));
        javaTypeToSqlTypeMap.put(Blob.class, new Integer(2004));
        javaTypeToSqlTypeMap.put(byte[].class, new Integer(2004));
        javaTypeToSqlTypeMap.put(Clob.class, new Integer(2005));
    }

    @Override
    public Object get(Class<?> type, ResultSet rs, int columnIndex) throws SQLException {
        if (type == String.class) {
            return rs.getString(columnIndex);
        }
        if (type == Integer.class) {
            if (rs.getObject(columnIndex) == null) {
                return null;
            }
            return rs.getInt(columnIndex);
        }
        if (type == Integer.TYPE) {
            return rs.getInt(columnIndex);
        }
        if (type == Long.class) {
            if (rs.getObject(columnIndex) == null) {
                return null;
            }
            return rs.getLong(columnIndex);
        }
        if (type == Long.TYPE) {
            return rs.getLong(columnIndex);
        }
        if (type == Short.class) {
            if (rs.getObject(columnIndex) == null) {
                return null;
            }
            return rs.getShort(columnIndex);
        }
        if (type == Short.TYPE) {
            return rs.getShort(columnIndex);
        }
        if (type == Double.class) {
            if (rs.getObject(columnIndex) == null) {
                return null;
            }
            return rs.getDouble(columnIndex);
        }
        if (type == Double.TYPE) {
            return rs.getDouble(columnIndex);
        }
        if (type == Float.class) {
            if (rs.getObject(columnIndex) == null) {
                return null;
            }
            return Float.valueOf(rs.getFloat(columnIndex));
        }
        if (type == Float.TYPE) {
            return Float.valueOf(rs.getFloat(columnIndex));
        }
        if (type == Boolean.class) {
            if (rs.getObject(columnIndex) == null) {
                return null;
            }
            return rs.getBoolean(columnIndex);
        }
        if (type == Boolean.TYPE) {
            return rs.getBoolean(columnIndex);
        }
        if (type == BigDecimal.class) {
            return rs.getBigDecimal(columnIndex);
        }
        if (type == Date.class) {
            return rs.getDate(columnIndex);
        }
        if (type == java.util.Date.class) {
            if (rs.getObject(columnIndex) == null) {
                return null;
            }
            return new java.util.Date(rs.getTimestamp(columnIndex).getTime());
        }
        if (type == Time.class) {
            return rs.getTime(columnIndex);
        }
        if (type == Timestamp.class) {
            return rs.getTimestamp(columnIndex);
        }
        if (type.isArray() && type.getComponentType() == Byte.TYPE) {
            if (rs.getObject(columnIndex) == null) {
                return null;
            }
            return IOUtil.readStream(rs.getBinaryStream(columnIndex));
        }
        throw new RuntimeException("Unsupported type: " + type.getName());
    }

    @Override
    public Object get(Class<?> type, ResultSet rs, String columnName) throws SQLException {
        if (type == String.class) {
            return rs.getString(columnName);
        }
        if (type == Integer.class) {
            if (rs.getObject(columnName) == null) {
                return null;
            }
            return rs.getInt(columnName);
        }
        if (type == Integer.TYPE) {
            return rs.getInt(columnName);
        }
        if (type == Long.class) {
            if (rs.getObject(columnName) == null) {
                return null;
            }
            return rs.getLong(columnName);
        }
        if (type == Long.TYPE) {
            return rs.getLong(columnName);
        }
        if (type == Short.class) {
            if (rs.getObject(columnName) == null) {
                return null;
            }
            return rs.getShort(columnName);
        }
        if (type == Short.TYPE) {
            return rs.getShort(columnName);
        }
        if (type == Double.class) {
            if (rs.getObject(columnName) == null) {
                return null;
            }
            return rs.getDouble(columnName);
        }
        if (type == Double.TYPE) {
            return rs.getDouble(columnName);
        }
        if (type == Float.class) {
            if (rs.getObject(columnName) == null) {
                return null;
            }
            return Float.valueOf(rs.getFloat(columnName));
        }
        if (type == Float.TYPE) {
            return Float.valueOf(rs.getFloat(columnName));
        }
        if (type == Boolean.class) {
            if (rs.getObject(columnName) == null) {
                return null;
            }
            return rs.getBoolean(columnName);
        }
        if (type == Boolean.TYPE) {
            return rs.getBoolean(columnName);
        }
        if (type == BigDecimal.class) {
            return rs.getBigDecimal(columnName);
        }
        if (type == Date.class) {
            return rs.getDate(columnName);
        }
        if (type == java.util.Date.class) {
            if (rs.getObject(columnName) == null) {
                return null;
            }
            return new java.util.Date(rs.getTimestamp(columnName).getTime());
        }
        if (type == Time.class) {
            return rs.getTime(columnName);
        }
        if (type == Timestamp.class) {
            return rs.getTimestamp(columnName);
        }
        if (type.isArray() && type.getComponentType() == Byte.TYPE) {
            if (rs.getObject(columnName) == null) {
                return null;
            }
            return IOUtil.readStream(rs.getBinaryStream(columnName));
        }
        throw new RuntimeException("Unsupported type: " + type.getName());
    }

    @Override
    public void set(Class<?> type, PreparedStatement stmt, Object value, int index) throws SQLException {
        if (value == null) {
            this.setNull(type, stmt, index);
            return;
        }
        if (type == String.class) {
            stmt.setString(index, (String)value);
        } else if (type == Integer.class) {
            stmt.setInt(index, (Integer)value);
        } else if (type == Long.class || type == Long.TYPE) {
            stmt.setLong(index, (Long)value);
        } else if (type == Short.class || type == Short.TYPE) {
            stmt.setShort(index, (Short)value);
        } else if (type == Double.class || type == Double.TYPE) {
            stmt.setDouble(index, (Double)value);
        } else if (type == Float.class || type == Float.TYPE) {
            stmt.setFloat(index, ((Float)value).floatValue());
        } else if (type == Boolean.class || type == Boolean.TYPE) {
            stmt.setBoolean(index, (Boolean)value);
        } else if (type == Boolean.class || type == Boolean.TYPE) {
            stmt.setBoolean(index, (Boolean)value);
        } else if (type == BigDecimal.class) {
            stmt.setBigDecimal(index, (BigDecimal)value);
        } else if (type == Date.class) {
            stmt.setDate(index, (Date)value);
        } else if (type == java.util.Date.class) {
            stmt.setTimestamp(index, new Timestamp(((java.util.Date)value).getTime()));
        } else if (type == Time.class) {
            stmt.setTime(index, (Time)value);
        } else if (type == Timestamp.class) {
            stmt.setTimestamp(index, (Timestamp)value);
        } else if (type.isArray() && type.getComponentType() == Byte.TYPE) {
            stmt.setBinaryStream(index, new ByteArrayInputStream((byte[])value));
        } else {
            throw new RuntimeException("Unsupported type: " + type.getName());
        }
    }

    @Override
    public Object get(Class<?> type, CallableStatement cs, int index) throws SQLException {
        Object value = null;
        boolean wasNullCheck = false;
        if (type == String.class) {
            value = cs.getString(index);
        } else if (type == Integer.class || type == Integer.TYPE) {
            value = cs.getInt(index);
            wasNullCheck = true;
        } else if (type == Long.class || type == Long.TYPE) {
            value = cs.getLong(index);
            wasNullCheck = true;
        } else if (type == Short.class || type == Short.TYPE) {
            value = cs.getShort(index);
            wasNullCheck = true;
        } else if (type == Double.class || type == Double.TYPE) {
            value = cs.getDouble(index);
            wasNullCheck = true;
        } else if (type == Float.class || type == Float.TYPE) {
            value = Float.valueOf(cs.getFloat(index));
            wasNullCheck = true;
        } else if (type == Boolean.class || type == Boolean.TYPE) {
            value = cs.getBoolean(index);
            wasNullCheck = true;
        } else if (type == BigDecimal.class) {
            value = cs.getBigDecimal(index);
        } else if (type == Date.class) {
            value = cs.getDate(index);
        } else if (type == java.util.Date.class) {
            value = new java.util.Date(cs.getTimestamp(index).getTime());
        } else if (type == Time.class) {
            value = cs.getTime(index);
        } else if (type == Timestamp.class) {
            value = cs.getTimestamp(index);
        } else if (type.isArray() && type.getComponentType() == Byte.TYPE) {
            Blob blob = cs.getBlob(index);
            value = IOUtil.readStream(blob.getBinaryStream());
        }
        if (wasNullCheck && value != null && cs.wasNull()) {
            value = null;
        }
        return value;
    }

    @Override
    public Object get(Class<?> type, CallableStatement cs, String parameterName) throws SQLException {
        Object value = null;
        boolean wasNullCheck = false;
        if (type == String.class) {
            value = cs.getString(parameterName);
        } else if (type == Integer.class || type == Integer.TYPE) {
            value = cs.getInt(parameterName);
            wasNullCheck = true;
        } else if (type == Long.class || type == Long.TYPE) {
            value = cs.getLong(parameterName);
            wasNullCheck = true;
        } else if (type == Short.class || type == Short.TYPE) {
            value = cs.getShort(parameterName);
            wasNullCheck = true;
        } else if (type == Double.class || type == Double.TYPE) {
            value = cs.getDouble(parameterName);
            wasNullCheck = true;
        } else if (type == Float.class || type == Float.TYPE) {
            value = Float.valueOf(cs.getFloat(parameterName));
            wasNullCheck = true;
        } else if (type == Boolean.class || type == Boolean.TYPE) {
            value = cs.getBoolean(parameterName);
            wasNullCheck = true;
        } else if (type == BigDecimal.class) {
            value = cs.getBigDecimal(parameterName);
        } else if (type == Date.class) {
            value = cs.getDate(parameterName);
        } else if (type == java.util.Date.class) {
            value = new java.util.Date(cs.getTimestamp(parameterName).getTime());
        } else if (type == Time.class) {
            value = cs.getTime(parameterName);
        } else if (type == Timestamp.class) {
            value = cs.getTimestamp(parameterName);
        } else if (type.isArray() && type.getComponentType() == Byte.TYPE) {
            Blob blob = cs.getBlob(parameterName);
            value = IOUtil.readStream(blob.getBinaryStream());
        }
        if (wasNullCheck && value != null && cs.wasNull()) {
            value = null;
        }
        return value;
    }

    @Override
    public void registerOutParameter(Class<?> type, CallableStatement cs, int index) throws SQLException {
        int sqlType = DefaultValueType.javaTypeToSqlType(type);
        cs.registerOutParameter(index, sqlType);
    }

    @Override
    public void registerOutParameter(Class<?> type, CallableStatement cs, String parameterName) throws SQLException {
        int sqlType = DefaultValueType.javaTypeToSqlType(type);
        cs.registerOutParameter(parameterName, sqlType);
    }

    public static int javaTypeToSqlType(Class<?> javaType) {
        Integer sqlType = javaTypeToSqlTypeMap.get(javaType);
        if (sqlType != null) {
            return sqlType;
        }
        if (Number.class.isAssignableFrom(javaType)) {
            return 2;
        }
        if (DefaultValueType.isStringValue(javaType)) {
            return 12;
        }
        if (DefaultValueType.isDateValue(javaType) || Calendar.class.isAssignableFrom(javaType)) {
            return 93;
        }
        return Integer.MIN_VALUE;
    }

    private static boolean isStringValue(Class<?> inValueType) {
        return CharSequence.class.isAssignableFrom(inValueType) || StringWriter.class.isAssignableFrom(inValueType);
    }

    private static boolean isDateValue(Class<?> inValueType) {
        return java.util.Date.class.isAssignableFrom(inValueType) && !Date.class.isAssignableFrom(inValueType) && !Time.class.isAssignableFrom(inValueType) && !Timestamp.class.isAssignableFrom(inValueType);
    }

    protected void setNull(Class<?> type, PreparedStatement stmt, int index) throws SQLException {
        int sqlType = DefaultValueType.javaTypeToSqlType(type);
        stmt.setNull(index, sqlType);
    }

    @Override
    public boolean isSupport(Class<?> type) {
        return type == String.class || type == Integer.class || type == Integer.TYPE || type == Long.class || type == Long.TYPE || type == Short.class || type == Short.TYPE || type == Double.class || type == Double.TYPE || type == Float.class || type == Float.TYPE || type == Boolean.class || type == Boolean.TYPE || type == BigDecimal.class || type == java.util.Date.class || type == Time.class || type == Timestamp.class || type.isArray() && type.getComponentType() == Byte.TYPE;
    }

    @Override
    public Class<?> getJavaType(int sqlType) {
        for (Map.Entry<Class<?>, Integer> entry : javaTypeToSqlTypeMap.entrySet()) {
            if (sqlType != entry.getValue() || DefaultValueType.isPrimitive(entry.getKey())) continue;
            return entry.getKey();
        }
        return null;
    }

    private static boolean isPrimitive(Class<?> type) {
        return type == Integer.TYPE || type == Long.TYPE || type == Short.TYPE || type == Double.TYPE || type == Float.TYPE || type == Boolean.TYPE;
    }
}

