/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.amateras.mirage.test;

import java.util.ArrayList;
import java.util.List;
import jp.sf.amateras.mirage.test.ExecutedSQLInfo;
import junit.framework.Assert;

public class MirageTestContext {
    private static List<Object> resultList = new ArrayList<Object>();
    private static List<ExecutedSQLInfo> executedSqlList = new ArrayList<ExecutedSQLInfo>();

    public static void initMirageTestContext() {
        resultList.clear();
        executedSqlList.clear();
    }

    public static void addResult(Object result) {
        resultList.add(result);
    }

    static boolean hasNextResult() {
        return !resultList.isEmpty();
    }

    static Object getNextResult() {
        return resultList.remove(0);
    }

    static void addExecutedSql(ExecutedSQLInfo executedSql) {
        System.out.println(String.format("[SQL] %s", MirageTestContext.normalizeSql(executedSql.getSql())));
        Object[] params = executedSql.getParams();
        int i = 0;
        while (i < params.length) {
            System.out.println(String.format("[SQL] params[%d]: %s", i, params[i]));
            ++i;
        }
        executedSqlList.add(executedSql);
    }

    public static void verifySqlCount(int expected) {
        Assert.assertEquals((int)expected, (int)executedSqlList.size());
    }

    public static void verifySql(int indexOfSql, String sql) {
        ExecutedSQLInfo executedSql = executedSqlList.get(indexOfSql);
        String result = executedSql.getSql();
        Assert.assertEquals((String)MirageTestContext.normalizeSql(sql), (String)MirageTestContext.normalizeSql(result));
    }

    public static void verifySqlByRegexp(int indexOfSql, String regexp) {
        ExecutedSQLInfo executedSql = executedSqlList.get(indexOfSql);
        String result = MirageTestContext.normalizeSql(executedSql.getSql());
        Assert.assertTrue((boolean)result.matches(regexp));
    }

    public static void verifySqlParameterCount(int indexOfSql, int expected) {
        ExecutedSQLInfo executedSql = executedSqlList.get(indexOfSql);
        Assert.assertEquals((int)expected, (int)executedSql.getParams().length);
    }

    public static void verifySqlParameter(int indexOfSql, int indexOfParam, Object value) {
        ExecutedSQLInfo executedSql = executedSqlList.get(indexOfSql);
        Object[] params = executedSql.getParams();
        if (value == null) {
            Assert.assertNull((Object)params[indexOfParam]);
        } else {
            Assert.assertEquals((Object)value, (Object)params[indexOfParam]);
        }
    }

    private static String normalizeSql(String sql) {
        sql = sql.replaceAll("\r\n", "\n");
        sql = sql.replaceAll("\r", "\n");
        sql = sql.replaceAll("\n", " ");
        sql = sql.replaceAll("[ \t]+", " ");
        sql = sql.toUpperCase();
        return sql;
    }
}

