/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.amateras.mirage.parser;

import java.lang.reflect.Array;
import java.util.List;
import jp.sf.amateras.mirage.parser.AbstractNode;
import jp.sf.amateras.mirage.parser.SqlContext;
import jp.sf.amateras.mirage.util.OgnlUtil;

public class ParenBindVariableNode
extends AbstractNode {
    private String expression;
    private Object parsedExpression;

    public ParenBindVariableNode(String expression) {
        this.expression = expression;
        this.parsedExpression = OgnlUtil.parseExpression(expression);
    }

    public String getExpression() {
        return this.expression;
    }

    public void accept(SqlContext ctx) {
        Object var = OgnlUtil.getValue(this.parsedExpression, ctx);
        if (var instanceof List) {
            this.bindArray(ctx, ((List)List.class.cast(var)).toArray());
        } else {
            if (var == null) {
                return;
            }
            if (var.getClass().isArray()) {
                this.bindArray(ctx, var);
            } else {
                ctx.addSql("?", var, var.getClass());
            }
        }
    }

    protected void bindArray(SqlContext ctx, Object array) {
        int length = Array.getLength(array);
        if (length == 0) {
            return;
        }
        Class<?> clazz = null;
        int i = 0;
        while (i < length) {
            Object o = Array.get(array, i);
            if (o != null) {
                clazz = o.getClass();
            }
            ++i;
        }
        ctx.addSql("(");
        Object value = Array.get(array, 0);
        ctx.addSql("?", value, clazz);
        int i2 = 1;
        while (i2 < length) {
            ctx.addSql(", ");
            value = Array.get(array, i2);
            ctx.addSql("?", value, clazz);
            ++i2;
        }
        ctx.addSql(")");
    }
}

