/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.amateras.mirage;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jp.sf.amateras.mirage.IterationCallback;
import jp.sf.amateras.mirage.bean.BeanDesc;
import jp.sf.amateras.mirage.bean.BeanDescFactory;
import jp.sf.amateras.mirage.dialect.Dialect;
import jp.sf.amateras.mirage.exception.SQLRuntimeException;
import jp.sf.amateras.mirage.naming.NameConverter;
import jp.sf.amateras.mirage.provider.ConnectionProvider;
import jp.sf.amateras.mirage.type.ValueType;
import jp.sf.amateras.mirage.util.JdbcUtil;
import jp.sf.amateras.mirage.util.MirageUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlExecutor {
    private static final Logger logger = Logger.getLogger(SqlExecutor.class.getName());
    private NameConverter nameConverter;
    private ConnectionProvider connectionProvider;
    private Dialect dialect;
    private List<ValueType> valueTypes = new ArrayList<ValueType>();

    public void setConnectionProvider(ConnectionProvider connectionProvider) {
        this.connectionProvider = connectionProvider;
    }

    public void setNameConverter(NameConverter nameConverter) {
        this.nameConverter = nameConverter;
    }

    public void addValueType(ValueType valueType) {
        this.valueTypes.add(valueType);
    }

    public void setDialect(Dialect dialect) {
        this.dialect = dialect;
    }

    private static void printParameters(Object[] params) {
        if (params == null) {
            return;
        }
        int i = 0;
        while (i < params.length) {
            logger.info(String.format("params[%d]=%s", i, params[i]));
            ++i;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> List<T> getResultList(Class<T> clazz, String sql, Object[] params) {
        ArrayList<T> arrayList;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.connectionProvider.getConnection().prepareStatement(sql);
            this.setParameters(stmt, params);
            ArrayList<T> list = new ArrayList<T>();
            if (logger.isLoggable(Level.INFO)) {
                logger.info(sql);
                SqlExecutor.printParameters(params);
            }
            rs = stmt.executeQuery();
            ResultSetMetaData meta = rs.getMetaData();
            int columnCount = meta.getColumnCount();
            BeanDesc beanDesc = BeanDescFactory.getBeanDesc(clazz);
            while (true) {
                if (!rs.next()) {
                    arrayList = list;
                    break;
                }
                T entity = MirageUtil.createEntity(clazz, rs, meta, columnCount, beanDesc, this.dialect, this.valueTypes, this.nameConverter);
                list.add(entity);
            }
        }
        catch (SQLException ex) {
            try {
                throw new SQLRuntimeException(ex);
                catch (RuntimeException ex2) {
                    throw ex2;
                }
                catch (Exception ex3) {
                    throw new RuntimeException(ex3);
                }
            }
            catch (Throwable throwable) {
                JdbcUtil.close(rs);
                JdbcUtil.close(stmt);
                throw throwable;
            }
        }
        JdbcUtil.close(rs);
        JdbcUtil.close(stmt);
        return arrayList;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T, R> R iterate(Class<T> clazz, IterationCallback<T, R> callback, String sql, Object[] params) {
        R r;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.connectionProvider.getConnection().prepareStatement(sql);
            this.setParameters(stmt, params);
            if (logger.isLoggable(Level.INFO)) {
                logger.info(sql);
                SqlExecutor.printParameters(params);
            }
            rs = stmt.executeQuery();
            ResultSetMetaData meta = rs.getMetaData();
            int columnCount = meta.getColumnCount();
            BeanDesc beanDesc = BeanDescFactory.getBeanDesc(clazz);
            R result = null;
            while (true) {
                if (!rs.next()) {
                    r = result;
                    break;
                }
                T entity = MirageUtil.createEntity(clazz, rs, meta, columnCount, beanDesc, this.dialect, this.valueTypes, this.nameConverter);
                result = callback.iterate(entity);
            }
        }
        catch (SQLException ex) {
            try {
                throw new SQLRuntimeException(ex);
                catch (RuntimeException ex2) {
                    throw ex2;
                }
                catch (Exception ex3) {
                    throw new RuntimeException(ex3);
                }
            }
            catch (Throwable throwable) {
                JdbcUtil.close(rs);
                JdbcUtil.close(stmt);
                throw throwable;
            }
        }
        JdbcUtil.close(rs);
        JdbcUtil.close(stmt);
        return r;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T getSingleResult(Class<T> clazz, String sql, Object[] params) throws SQLRuntimeException {
        ResultSet rs;
        PreparedStatement stmt;
        block7: {
            T t;
            stmt = null;
            rs = null;
            try {
                T entity;
                stmt = this.connectionProvider.getConnection().prepareStatement(sql);
                this.setParameters(stmt, params);
                if (logger.isLoggable(Level.INFO)) {
                    logger.info(sql);
                    SqlExecutor.printParameters(params);
                }
                rs = stmt.executeQuery();
                ResultSetMetaData meta = rs.getMetaData();
                int columnCount = meta.getColumnCount();
                BeanDesc beanDesc = BeanDescFactory.getBeanDesc(clazz);
                if (!rs.next()) break block7;
                t = entity = MirageUtil.createEntity(clazz, rs, meta, columnCount, beanDesc, this.dialect, this.valueTypes, this.nameConverter);
            }
            catch (SQLException ex) {
                try {
                    throw new SQLRuntimeException(ex);
                    catch (RuntimeException ex2) {
                        throw ex2;
                    }
                    catch (Exception ex3) {
                        throw new RuntimeException(ex3);
                    }
                }
                catch (Throwable throwable) {
                    JdbcUtil.close(rs);
                    JdbcUtil.close(stmt);
                    throw throwable;
                }
            }
            JdbcUtil.close(rs);
            JdbcUtil.close(stmt);
            return t;
        }
        JdbcUtil.close(rs);
        JdbcUtil.close(stmt);
        return null;
    }

    public int executeUpdateSql(String sql, Object[] params) throws SQLRuntimeException {
        int n;
        PreparedStatement stmt = null;
        try {
            int result;
            Connection conn = this.connectionProvider.getConnection();
            if (logger.isLoggable(Level.INFO)) {
                logger.info(sql);
                SqlExecutor.printParameters(params);
            }
            stmt = conn.prepareStatement(sql);
            this.setParameters(stmt, params);
            n = result = stmt.executeUpdate();
        }
        catch (SQLException ex) {
            try {
                throw new SQLRuntimeException(ex);
            }
            catch (Throwable throwable) {
                JdbcUtil.close(stmt);
                throw throwable;
            }
        }
        JdbcUtil.close(stmt);
        return n;
    }

    public int executeBatchUpdateSql(String sql, List<Object[]> paramsList) throws SQLRuntimeException {
        int n;
        PreparedStatement stmt = null;
        try {
            Connection conn = this.connectionProvider.getConnection();
            if (logger.isLoggable(Level.INFO)) {
                logger.info(sql);
                int i = 0;
                while (i < paramsList.size()) {
                    Object[] params = paramsList.get(i);
                    logger.info("[" + i + "]");
                    SqlExecutor.printParameters(params);
                    ++i;
                }
            }
            stmt = conn.prepareStatement(sql);
            for (Object[] params : paramsList) {
                this.setParameters(stmt, params);
                stmt.addBatch();
            }
            int[] results = stmt.executeBatch();
            int updateRows = 0;
            int[] nArray = results;
            int n2 = results.length;
            int n3 = 0;
            while (n3 < n2) {
                int result = nArray[n3];
                updateRows += result;
                ++n3;
            }
            n = updateRows;
        }
        catch (SQLException ex) {
            try {
                throw new SQLRuntimeException(ex);
            }
            catch (Throwable throwable) {
                JdbcUtil.close(stmt);
                throw throwable;
            }
        }
        JdbcUtil.close(stmt);
        return n;
    }

    protected void setParameters(PreparedStatement stmt, Object[] vars) throws SQLException {
        int i = 0;
        while (i < vars.length) {
            if (vars[i] == null) {
                stmt.setObject(i + 1, null);
            } else {
                ValueType valueType2;
                Class<?> varType = vars[i].getClass();
                if (this.dialect.getValueType() != null && (valueType2 = this.dialect.getValueType()).isSupport(varType)) {
                    valueType2.set(varType, stmt, vars[i], i + 1);
                } else {
                    for (ValueType valueType2 : this.valueTypes) {
                        if (!valueType2.isSupport(varType)) continue;
                        valueType2.set(varType, stmt, vars[i], i + 1);
                    }
                }
            }
            ++i;
        }
    }
}

