/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amateras.air.wizards.file;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import net.sf.amateras.air.wizards.file.AbstractFileCreationPage;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFileWizard
extends Wizard
implements INewWizard {
    protected ISelection selection;
    protected AbstractFileCreationPage page;

    public abstract AbstractFileCreationPage createPage(ISelection var1);

    public abstract InputStream openContentStream(String var1, String var2, String var3, Map<String, String> var4);

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.page = this.createPage(this.selection);
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        IRunnableWithProgress op = this.getRunnableFinish();
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)realException.getMessage());
            return false;
        }
        return true;
    }

    private IRunnableWithProgress getRunnableFinish() {
        final IPath path = this.page.getFilePath();
        final String packg = this.page.getPackageName();
        final String template = this.page.getTemplate();
        final Map<String, String> params = this.page.getParameters();
        return new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        AbstractFileWizard.this.doFinish(path, packg, template, params, monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
    }

    protected void doFinish(IPath path, String packg, String template, Map<String, String> params, IProgressMonitor monitor) throws CoreException {
        String fileName = path.lastSegment();
        monitor.beginTask("Creating " + fileName, 2);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IPath contPath = path.removeLastSegments(1);
        IResource resource = root.findMember(contPath);
        IContainer container = null;
        if (resource == null || !resource.exists()) {
            if (contPath.segmentCount() > 1 && root.getProject(contPath.segment(0)).exists()) {
                IProject project = root.getProject(contPath.segment(0));
                container = this.createFolder((IContainer)project, contPath, monitor);
            }
        } else if (!(resource instanceof IContainer)) {
            this.throwCoreException("\"" + path + "\" is not a valid Container.");
        }
        if (container == null) {
            container = (IContainer)resource;
        }
        IFile file = container.getFile((IPath)new Path(fileName));
        try {
            String fileString = path.removeFileExtension().lastSegment();
            InputStream stream = this.openContentStream(fileString, packg, template, params);
            if (file.exists()) {
                file.setContents(stream, true, true, monitor);
            } else {
                file.create(stream, true, monitor);
            }
            stream.close();
        }
        catch (IOException iOException) {}
        this.doOther(container, path, params, monitor);
        monitor.worked(1);
        monitor.setTaskName("Opening file for editing...");
        this.asyncActivePage(file);
        monitor.worked(1);
    }

    protected void doOther(IContainer container, IPath path, Map<String, String> params, IProgressMonitor moniter) throws CoreException {
    }

    private IFolder createFolder(IContainer project, IPath containerPath, IProgressMonitor monitor) throws CoreException {
        IFolder folder = null;
        int i = 1;
        while (i < containerPath.segmentCount()) {
            Path segPath = new Path(containerPath.segment(i));
            if (!(folder = folder == null ? project.getFolder((IPath)segPath) : folder.getFolder((IPath)segPath)).exists()) {
                folder.create(false, true, monitor);
            }
            ++i;
        }
        return folder;
    }

    protected void throwCoreException(String message) throws CoreException {
        Status status = new Status(4, "AIR GEAR", 0, message, null);
        throw new CoreException((IStatus)status);
    }

    protected void asyncActivePage(final IFile file) {
        this.getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                BasicNewProjectResourceWizard.selectAndReveal((IResource)file, (IWorkbenchWindow)window);
                try {
                    IDE.openEditor((IWorkbenchPage)window.getActivePage(), (IFile)file, (boolean)true);
                }
                catch (PartInitException partInitException) {}
            }
        });
    }
}

