/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amateras.air.wizards;

import java.io.File;
import java.io.FileInputStream;
import java.util.Map;
import net.sf.amateras.air.AIRPlugin;
import net.sf.amateras.air.wizards.AIRHTMLProjectPropertiesWizardPage;
import net.sf.amateras.air.wizards.AIRProjectWizardPage;
import net.sf.amateras.air.wizards.AbstractAIRProjectPropertiesWizardPage;
import net.sf.amateras.air.wizards.AbstractNewAIRProjectWizard;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.preference.IPreferenceStore;

public class NewAIRHTMLProjectWizard
extends AbstractNewAIRProjectWizard {
    public NewAIRHTMLProjectWizard() {
        this.setWindowTitle("New AIR HTML Project");
    }

    protected void addProjectSpecificParameters(Map params) {
        String mainHTML = ((AIRHTMLProjectPropertiesWizardPage)this.page2).getMainHTML();
        params.put("content", mainHTML);
    }

    protected AIRProjectWizardPage createPage1() {
        AIRProjectWizardPage page = new AIRProjectWizardPage("New HTML AIR Application Project", 0);
        page.setTitle("New HTML AIR Application Project");
        page.setDescription("Create new HTML based AIR application project.");
        return page;
    }

    protected AbstractAIRProjectPropertiesWizardPage createPage2() {
        AIRHTMLProjectPropertiesWizardPage page = new AIRHTMLProjectPropertiesWizardPage("HTML Project Properties");
        page.setTitle("HTML Project Properties");
        page.setDescription("Input your project properties.");
        return page;
    }

    protected void createProjectSpecificResources(IProject project, String descriptorTemplateName, Map params, IProgressMonitor monitor) throws Exception {
        this.createFile(project, "application.xml", this.getTemplateContents(descriptorTemplateName), params, monitor);
        this.createFile(project, (String)params.get("content"), NewAIRHTMLProjectWizard.class.getResourceAsStream("main.html"), params, monitor);
        IPreferenceStore store = AIRPlugin.getDefault().getPreferenceStore();
        String sdkPath = store.getString("airSdkPath");
        File javaScript = new File(sdkPath, "frameworks/AIRAliases.js");
        this.createFile(project, "AIRAliases.js", new FileInputStream(javaScript), null, monitor);
    }

    protected String getNatureId() {
        return "net.sf.amateras.air.AIRHTMLProjectNature";
    }
}

