/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amateras.air.wizards;

import java.io.IOException;
import java.util.ArrayList;
import net.sf.amateras.air.AIRPlugin;
import net.sf.amateras.air.util.UIUtil;
import net.sf.amateras.air.wizards.ADTRunner;
import net.sf.amateras.air.wizards.CreateCertificateDialog;
import org.eclipse.core.internal.resources.File;
import org.eclipse.core.internal.resources.Folder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class ExportAIRWizardPage
extends WizardPage {
    private IProject project;
    private CheckboxTreeViewer treeViewer;
    private Text packageName;
    private Text storeType;
    private Text keystore;
    private Text storepass;
    private String descriptor;
    private ScopedPreferenceStore store;

    protected ExportAIRWizardPage(IProject project) {
        super("ExportAIRWizardPage");
        this.setTitle(AIRPlugin.getResourceString("EXPORT_AIR_PACKAGE_TITLE"));
        this.setDescription(AIRPlugin.getResourceString("EXPORT_AIR_PACKAGE_DESCRIPTION"));
        this.project = project;
        this.store = new ScopedPreferenceStore((IScopeContext)new ProjectScope(this.project), "net.sf.amateras.air");
        this.descriptor = this.store.getString("decriptor");
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        this.treeViewer = new CheckboxTreeViewer(composite);
        this.treeViewer.getControl().setLayoutData((Object)new GridData(1808));
        this.treeViewer.setContentProvider((IContentProvider)new WorkbenchContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.treeViewer.setInput((Object)this.project);
        this.treeViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent arg0) {
                ExportAIRWizardPage.this.doValidate();
            }
        });
        Control o = this.treeViewer.getControl();
        String[] listArray = null;
        String list = this.store.getString("exportPackList");
        if (list != null && list.length() != 0) {
            listArray = list.split(";");
        }
        this.checkDescription((Widget)o, listArray);
        Composite exportPanel = new Composite(composite, 0);
        exportPanel.setLayout((Layout)new GridLayout(2, false));
        exportPanel.setLayoutData((Object)new GridData(768));
        UIUtil.createLabel(AIRPlugin.getResourceString("EXPORT_AIR_PACKAGE_NAME"), exportPanel);
        this.packageName = new Text(exportPanel, 2048);
        this.packageName.setLayoutData((Object)new GridData(768));
        String name = this.store.getString("exportPackageName");
        if (name == null || name.length() == 0) {
            name = String.valueOf(this.project.getName()) + ".air";
        }
        this.packageName.setText(name);
        this.packageName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExportAIRWizardPage.this.doValidate();
            }
        });
        Group group = new Group(composite, 0);
        group.setText(AIRPlugin.getResourceString("CERTIFICATE"));
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)new GridData(768));
        UIUtil.createLabel(AIRPlugin.getResourceString("EXPORT_AIR_PACKAGE_STORE_TYPE"), (Composite)group);
        this.storeType = new Text((Composite)group, 2048);
        this.storeType.setLayoutData((Object)new GridData(768));
        String work = this.store.getString("exportStoreType");
        if (work == null || work.length() == 0) {
            work = "pkcs12";
        }
        this.storeType.setText(work);
        this.storeType.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExportAIRWizardPage.this.doValidate();
            }
        });
        UIUtil.createLabel(AIRPlugin.getResourceString("EXPORT_AIR_PACKAGE_KEY_STORE"), (Composite)group);
        Composite panel = new Composite((Composite)group, 0);
        panel.setLayout((Layout)new GridLayout(2, false));
        panel.setLayoutData((Object)new GridData(768));
        this.keystore = new Text(panel, 2048);
        this.keystore.setLayoutData((Object)new GridData(768));
        work = this.store.getString("exportKeyStore");
        if (work == null || work.length() == 0) {
            work = "";
        }
        this.keystore.setText(work);
        this.keystore.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExportAIRWizardPage.this.doValidate();
            }
        });
        UIUtil.createBrowseFileButton(this.keystore, panel);
        UIUtil.createLabel(AIRPlugin.getResourceString("EXPORT_AIR_PACKAGE_STOREPASS"), (Composite)group);
        this.storepass = new Text((Composite)group, 0x400800);
        this.storepass.setLayoutData((Object)new GridData(768));
        work = this.store.getString("exportStorePass");
        if (work == null || work.length() == 0) {
            work = "";
        }
        this.storepass.setText(work);
        this.storepass.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExportAIRWizardPage.this.doValidate();
            }
        });
        UIUtil.createLabel("", (Composite)group);
        Button button = new Button((Composite)group, 8);
        button.setText(AIRPlugin.getResourceString("CREATE_CERTIFICATE"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                CreateCertificateDialog dialog = new CreateCertificateDialog(ExportAIRWizardPage.this.getShell(), ExportAIRWizardPage.this.project, ExportAIRWizardPage.this.keystore, ExportAIRWizardPage.this.storepass);
                dialog.open();
                dialog = null;
            }
        });
        this.setControl((Control)composite);
        this.doValidate();
    }

    private void checkDescription(Widget o, String[] listArray) {
        Item[] items = this.getChildren(o);
        int i = 0;
        while (i < items.length) {
            Item item = items[i];
            if (item instanceof TreeItem) {
                this.setDefaultChecked((TreeItem)item, listArray);
            }
            this.checkDescription((Widget)item, listArray);
            ++i;
        }
    }

    private Item[] getChildren(Widget o) {
        if (o instanceof TreeItem) {
            return ((TreeItem)o).getItems();
        }
        if (o instanceof Tree) {
            return ((Tree)o).getItems();
        }
        return null;
    }

    private void setDefaultChecked(TreeItem item, String[] listArray) {
        Object data = item.getData();
        if (data != null) {
            String fileName = null;
            if (data instanceof File) {
                fileName = ((File)data).getName();
            } else if (data instanceof Folder) {
                fileName = ((Folder)data).getName();
            }
            if (fileName.equals(this.descriptor)) {
                item.setChecked(true);
            } else if (listArray != null) {
                String[] stringArray = listArray;
                int n = listArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String check = stringArray[n2];
                    if (fileName.equals(check)) {
                        item.setChecked(true);
                        return;
                    }
                    ++n2;
                }
            } else if (data instanceof File && (fileName.endsWith(".html") || fileName.endsWith(".swf"))) {
                item.setChecked(true);
            }
        }
    }

    private void doValidate() {
        if (this.treeViewer.getCheckedElements().length == 0) {
            this.setErrorMessage(AIRPlugin.getResourceString("EXPORT_AIR_CHECK_RESOURCE"));
            this.setPageComplete(false);
            return;
        }
        if (this.packageName.getText().length() == 0) {
            this.setErrorMessage(AIRPlugin.getResourceString("EXPORT_AIR_CHECK_NAME"));
            this.setPageComplete(false);
            return;
        }
        if (this.storeType.getText().length() == 0) {
            this.setErrorMessage(AIRPlugin.getResourceString("EXPORT_AIR_CHECK_STORE_TYPE"));
            this.setPageComplete(false);
            return;
        }
        if (this.keystore.getText().length() == 0) {
            this.setErrorMessage(AIRPlugin.getResourceString("EXPORT_AIR_CHECK_STORE"));
            this.setPageComplete(false);
            return;
        }
        this.setErrorMessage(null);
        this.setPageComplete(true);
    }

    public boolean finish() {
        String descriptor = this.store.getString("decriptor");
        this.store.setValue("exportStoreType", this.storeType.getText());
        this.store.setValue("exportKeyStore", this.keystore.getText());
        this.store.setValue("exportStorePass", this.storepass.getText());
        this.store.setValue("exportPackageName", this.packageName.getText());
        Object[] checkedElements = this.treeViewer.getCheckedElements();
        ArrayList<String> options = new ArrayList<String>();
        options.add("-package");
        options.add("-storetype");
        options.add(this.storeType.getText());
        options.add("-keystore");
        options.add(this.keystore.getText());
        options.add("-storepass");
        options.add(this.storepass.getText());
        options.add(this.packageName.getText());
        ArrayList<IResource> resources = new ArrayList<IResource>();
        int i = 0;
        while (i < checkedElements.length) {
            if (checkedElements[i] instanceof IResource) {
                if (((IResource)checkedElements[i]).getName().endsWith(descriptor)) {
                    resources.add(0, (IResource)checkedElements[i]);
                } else {
                    resources.add((IResource)checkedElements[i]);
                }
            }
            ++i;
        }
        StringBuilder sb = new StringBuilder();
        for (IResource resource : resources) {
            sb.append(resource.getProjectRelativePath().toOSString()).append(";");
        }
        this.store.setValue("exportPackList", sb.toString());
        try {
            this.store.save();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ADTRunner runner = new ADTRunner();
        return runner.run(this.project, options, resources);
    }
}

