/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amateras.air.wizards;

import java.util.ArrayList;
import java.util.List;
import net.sf.amateras.air.AIRPlugin;
import net.sf.amateras.air.util.UIUtil;
import net.sf.amateras.air.wizards.ADTRunner;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CreateCertificateDialog
extends TitleAreaDialog {
    private Text certificateName;
    private Text organaizationalUnit;
    private Text organaizationalName;
    private Text country;
    private Text password;
    private Text type;
    private Text saveAs;
    private Text storeText;
    private Text passText;
    private IProject project;
    private List<CheckEntry> needText = new ArrayList<CheckEntry>();

    public CreateCertificateDialog(Shell parentShell, IProject project, Text storeText, Text passText) {
        super(parentShell);
        this.project = project;
        this.storeText = storeText;
        this.passText = passText;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(this.getMessage("CREATE_CERTIFICATE", new Object[0]));
        Composite area = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(area, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(768));
        this.certificateName = this.createText("CertificateName", composite, true);
        this.password = this.createText("Password", composite, true);
        this.type = this.createText("Type", composite, true);
        Group group = new Group(area, 0);
        group.setText("optional");
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)new GridData(768));
        this.organaizationalUnit = this.createText("OrganaizationalUnit", (Composite)group, false);
        this.organaizationalName = this.createText("OrganaizationalName", (Composite)group, false);
        this.country = this.createText("Country", (Composite)group, false);
        this.saveAs = this.createFileText("Save as", composite, true);
        return parent;
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.certificateName.setText("SelfSigned");
        this.type.setText("1024-RSA");
        this.saveAs.setText(String.valueOf(this.project.getName()) + ".p12");
        this.doValidate();
        return control;
    }

    protected void okPressed() {
        this.storeText.setText(this.saveAs.getText());
        this.passText.setText(this.password.getText());
        ArrayList<String> args = new ArrayList<String>();
        args.add("-certificate");
        args.add("-cn");
        args.add(this.certificateName.getText());
        if (this.organaizationalUnit.getText().length() != 0) {
            args.add("-ou");
            args.add(this.organaizationalUnit.getText());
        }
        if (this.organaizationalName.getText().length() != 0) {
            args.add("-o");
            args.add(this.organaizationalName.getText());
        }
        if (this.country.getText().length() != 0) {
            args.add("-c");
            args.add(this.country.getText());
        }
        args.add(this.type.getText());
        args.add(this.saveAs.getText());
        args.add(this.password.getText());
        ADTRunner runner = new ADTRunner();
        runner.run(this.project, args);
        super.okPressed();
    }

    private Text createText(String label, Composite parent, boolean isNeed) {
        UIUtil.createLabel(label, parent);
        Text text = new Text(parent, 2048);
        text.setLayoutData((Object)new GridData(768));
        if (isNeed) {
            this.needText.add(new CheckEntry(text, label));
            text.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    CreateCertificateDialog.this.doValidate();
                }
            });
        }
        return text;
    }

    private Text createFileText(String label, Composite parent, boolean isNeed) {
        UIUtil.createLabel(label, parent);
        Composite panel = new Composite(parent, 0);
        panel.setLayout((Layout)new GridLayout(2, false));
        panel.setLayoutData((Object)new GridData(768));
        Text text = new Text(panel, 2048);
        text.setLayoutData((Object)new GridData(768));
        if (isNeed) {
            this.needText.add(new CheckEntry(text, label));
            text.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    CreateCertificateDialog.this.doValidate();
                }
            });
        }
        UIUtil.createBrowseFileButton(text, panel);
        return text;
    }

    private void doValidate() {
        for (CheckEntry check : this.needText) {
            if (check.getText().getText().length() != 0) continue;
            this.setErrorMessage(this.getMessage("IS_NEED", check.getMessage()));
            this.getButton(0).setEnabled(false);
            return;
        }
        this.setErrorMessage(null);
        this.getButton(0).setEnabled(true);
    }

    private String getMessage(String key, Object ... args) {
        return AIRPlugin.getResourceString(key, args);
    }

    class CheckEntry {
        private Text text;
        private String message;

        CheckEntry(Text text, String message) {
            this.text = text;
            this.message = message;
        }

        public Text getText() {
            return this.text;
        }

        public void setText(Text text) {
            this.text = text;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }
    }
}

