/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amateras.air.wizards;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.Map;
import net.sf.amateras.air.AIRPlugin;
import net.sf.amateras.air.wizards.AbstractProjectWizardPage;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.wizards.newresource.ResourceMessages;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;

public abstract class AbstractNewProjectWizard
extends Wizard
implements INewWizard,
IExecutableExtension {
    protected IProject newProject;
    protected AbstractProjectWizardPage page1;
    protected WizardPage page2;
    protected IConfigurationElement config;

    protected abstract AbstractProjectWizardPage createPage1();

    protected abstract WizardPage createPage2();

    protected abstract void addProjectSpecificParameters(Map var1);

    protected abstract void createProjectSpecificResources(IProject var1, String var2, Map var3, IProgressMonitor var4) throws Exception;

    protected abstract String getNatureId();

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.config = config;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void addPages() {
        this.page1 = this.createPage1();
        this.addPage((IWizardPage)this.page1);
        this.page2 = this.createPage2();
        if (this.page2 != null) {
            this.addPage((IWizardPage)this.page2);
        }
    }

    public boolean performFinish() {
        this.createNewProject();
        if (this.newProject == null) {
            return false;
        }
        BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.config);
        return true;
    }

    protected void createFile(IProject project, String path, InputStream in, Map params, IProgressMonitor monitor) throws Exception {
        if (params == null) {
            IFile file = project.getFile((IPath)new Path(path));
            file.create(in, true, monitor);
            return;
        }
        try {
            byte[] buf = new byte[in.available()];
            in.read(buf);
            String xml = new String(buf, "UTF-8");
            Object[] entries = params.entrySet().toArray();
            int i = 0;
            while (i < entries.length) {
                Map.Entry entry = (Map.Entry)entries[i];
                xml = xml.replaceAll("\\$\\{" + entry.getKey() + "\\}", (String)entry.getValue());
                ++i;
            }
            IFile file = project.getFile((IPath)new Path(path));
            file.create((InputStream)new ByteArrayInputStream(xml.getBytes("UTF-8")), true, monitor);
        }
        finally {
            in.close();
        }
    }

    private void createProject(IProjectDescription description, IProject projectHandle, IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        try {
            monitor.beginTask("", 2000);
            projectHandle.create(description, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            projectHandle.open(128, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
        }
        finally {
            monitor.done();
        }
    }

    private IProject createNewProject() {
        if (this.newProject != null) {
            return this.newProject;
        }
        final IProject newProjectHandle = this.page1.getProjectHandle();
        URI location = null;
        if (!this.page1.useDefaults()) {
            location = this.page1.getLocationURI();
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        final IProjectDescription description = workspace.newProjectDescription(newProjectHandle.getName());
        description.setLocationURI(location);
        final Map params = this.createParamMap(this.page2);
        this.addProjectSpecificParameters(params);
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException {
                AbstractNewProjectWizard.this.createProject(description, newProjectHandle, monitor);
                AIRPlugin.addNature(newProjectHandle, AbstractNewProjectWizard.this.getNatureId());
                AbstractNewProjectWizard.this.createResource(newProjectHandle, monitor, params);
            }
        };
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof CoreException) {
                if (((CoreException)t).getStatus().getCode() == 275) {
                    MessageDialog.openError((Shell)this.getShell(), (String)ResourceMessages.NewProject_errorMessage, (String)NLS.bind((String)ResourceMessages.NewProject_caseVariantExistsError, (Object)newProjectHandle.getName()));
                } else {
                    ErrorDialog.openError((Shell)this.getShell(), (String)ResourceMessages.NewProject_errorMessage, null, (IStatus)((CoreException)t).getStatus());
                }
            } else {
                IDEWorkbenchPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.ui.ide", 0, t.toString(), t));
                MessageDialog.openError((Shell)this.getShell(), (String)ResourceMessages.NewProject_errorMessage, (String)NLS.bind((String)ResourceMessages.NewProject_internalError, (Object)t.getMessage()));
            }
            return null;
        }
        this.newProject = newProjectHandle;
        return this.newProject;
    }

    protected abstract Map createParamMap(WizardPage var1);

    protected abstract void createResource(IProject var1, IProgressMonitor var2, Map var3);
}

