/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amateras.air.wizards;

import java.io.File;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import net.sf.amateras.air.AIRPlugin;
import net.sf.amateras.air.util.ProcessUtil;
import net.sf.amateras.air.util.UIUtil;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.w3c.dom.Document;

public abstract class AbstractAIRProjectPropertiesWizardPage
extends WizardPage {
    private Text applicationId;
    private Text applicationName;
    private Text description;
    private Text copyright;
    private Text icon16;
    private Text icon32;
    private Text icon48;
    private Text icon128;
    private Combo descriptorVersion;
    private int projectType;

    protected AbstractAIRProjectPropertiesWizardPage(String pageName, int projectType) {
        super(pageName);
        this.projectType = projectType;
    }

    protected abstract void createProjectDependsFields(Composite var1);

    protected void projectNameChanged(String projectName) {
        this.applicationId.setText(projectName.replaceAll("[-_]", ""));
        this.applicationName.setText(projectName);
    }

    protected int getProjectType() {
        return this.projectType;
    }

    public void createControl(Composite parent) {
        String sdkPath = ProcessUtil.getAirSdkPath();
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(1808));
        UIUtil.createLabel("ID", composite);
        this.applicationId = new Text(composite, 2048);
        this.applicationId.setLayoutData((Object)new GridData(768));
        UIUtil.createLabel("Name", composite);
        this.applicationName = new Text(composite, 2048);
        this.applicationName.setLayoutData((Object)new GridData(768));
        UIUtil.createLabel("Description", composite);
        this.description = new Text(composite, 2050);
        this.description.setLayoutData((Object)new GridData(768));
        UIUtil.createLabel("Copyright", composite);
        this.copyright = new Text(composite, 2048);
        this.copyright.setLayoutData((Object)new GridData(768));
        UIUtil.createLabel("ApplicationDescriptor", composite);
        this.descriptorVersion = new Combo(composite, 2056);
        this.descriptorVersion.setLayoutData((Object)new GridData(768));
        TemplateStore templateStore = AIRPlugin.getDefault().getTemplateDescriptorStore();
        String path = this.getAirNameSpacePath();
        Template[] templateArray = templateStore.getTemplates();
        int n = templateArray.length;
        int n2 = 0;
        while (n2 < n) {
            Template template = templateArray[n2];
            this.descriptorVersion.add(template.getName());
            if (path != null && template.getDescription().equals(path)) {
                this.descriptorVersion.setText(template.getName());
            }
            ++n2;
        }
        if (this.descriptorVersion.getText().length() == 0) {
            this.descriptorVersion.setText("1.1");
        }
        this.createProjectDependsFields(composite);
        Group icons = new Group(composite, 0);
        icons.setText("Icons");
        icons.setLayout((Layout)new GridLayout(3, false));
        icons.setLayoutData((Object)UIUtil.createGridData(2));
        UIUtil.createLabel("16 x 16", (Composite)icons);
        this.icon16 = new Text((Composite)icons, 2048);
        this.icon16.setLayoutData((Object)new GridData(768));
        this.icon16.setText(this.getFileAbsolutePath(sdkPath, "samples/icons/AIRApp_16.png"));
        UIUtil.createBrowseFileButton(this.icon16, (Composite)icons);
        UIUtil.createLabel("32 x 32", (Composite)icons);
        this.icon32 = new Text((Composite)icons, 2048);
        this.icon32.setLayoutData((Object)new GridData(768));
        this.icon32.setText(this.getFileAbsolutePath(sdkPath, "samples/icons/AIRApp_32.png"));
        UIUtil.createBrowseFileButton(this.icon32, (Composite)icons);
        UIUtil.createLabel("48 x 48", (Composite)icons);
        this.icon48 = new Text((Composite)icons, 2048);
        this.icon48.setLayoutData((Object)new GridData(768));
        this.icon48.setText(this.getFileAbsolutePath(sdkPath, "samples/icons/AIRApp_48.png"));
        UIUtil.createBrowseFileButton(this.icon48, (Composite)icons);
        UIUtil.createLabel("128 x 128", (Composite)icons);
        this.icon128 = new Text((Composite)icons, 2048);
        this.icon128.setLayoutData((Object)new GridData(768));
        this.icon128.setText(this.getFileAbsolutePath(sdkPath, "samples/icons/AIRApp_128.png"));
        UIUtil.createBrowseFileButton(this.icon128, (Composite)icons);
        this.setControl((Control)composite);
    }

    private String getAirNameSpacePath() {
        File file;
        String path = ProcessUtil.getAirSdkPath();
        if (path != null && (file = new File(String.valueOf(path) + "/templates/air/descriptor-template.xml")).exists()) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            try {
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document doc = builder.parse(file);
                return doc.getDocumentElement().getAttributes().getNamedItem("xmlns").getNodeValue();
            }
            catch (Exception exception) {}
        }
        return null;
    }

    private String getFileAbsolutePath(String sdkPath, String path) {
        if (sdkPath == null) {
            return "";
        }
        return new File(sdkPath, path).getAbsolutePath();
    }

    public String getApplicationId() {
        return this.applicationId.getText();
    }

    public String getApplicationName() {
        return this.applicationName.getText();
    }

    public String getCopyright() {
        return this.copyright.getText();
    }

    public abstract String getVisible();

    public String getApplicationDescription() {
        return this.description.getText();
    }

    public String getDescriptorTemplateName() {
        return this.descriptorVersion.getText();
    }

    public String getIcon128() {
        return this.icon128.getText();
    }

    public String getIcon16() {
        return this.icon16.getText();
    }

    public String getIcon32() {
        return this.icon32.getText();
    }

    public String getIcon48() {
        return this.icon48.getText();
    }
}

