/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amateras.air.util;

import java.io.StringWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sf.amateras.air.AIRPlugin;
import org.apache.commons.jxpath.JXPathContext;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLUtil {
    public static final String DESCRIPTOR_NS = "http://ns.adobe.com/air/application/1.0";
    public static final String MXML_NS = "http://www.adobe.com/2006/mxml";

    public static String escape(String text) {
        text = text.replaceAll("&", "&amp;");
        text = text.replaceAll("<", "&lt;");
        text = text.replaceAll(">", "&gt;");
        text = text.replaceAll("\"", "&quot;");
        return text;
    }

    public static Map<String, String> createNsMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("a", DESCRIPTOR_NS);
        map.put("mx", MXML_NS);
        return map;
    }

    public static String getMainFile(IProject project) throws Exception {
        ScopedPreferenceStore projectStore = new ScopedPreferenceStore((IScopeContext)new ProjectScope(project), "net.sf.amateras.air");
        String descriptor = projectStore.getString("decriptor");
        IFile targetFile = project.getFile((IPath)new Path(descriptor));
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.parse(targetFile.getContents());
        Node[] nodes = XMLUtil.evalXPath(doc, XMLUtil.createNsMap(), "a:application/a:initialWindow/a:content/text()");
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < nodes.length) {
            Text text = (Text)nodes[i];
            sb.append(text.getNodeValue());
            ++i;
        }
        return sb.toString().trim();
    }

    public static Map<String, IFile> getIncludeASFiles(IFile mainFile, Map<String, IFile> appendList) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(mainFile.getContents());
            String path = "//" + AIRPlugin.getDefault().getNameSpacePrefix() + "Script/@source";
            Node[] nodes = XMLUtil.evalXPath(doc, null, path);
            int i = 0;
            while (i < nodes.length) {
                if (nodes[i].getNodeType() == 2) {
                    String text = nodes[i].getNodeValue();
                    appendList.put(text, mainFile);
                }
                ++i;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return appendList;
    }

    public static Node[] evalXPath(Node node, Map nsMap, String xpath) {
        try {
            JXPathContext ctx = JXPathContext.newContext((Object)node);
            if (nsMap != null) {
                Object[] entries = nsMap.entrySet().toArray();
                int i = 0;
                while (i < entries.length) {
                    Map.Entry entry = (Map.Entry)entries[i];
                    ctx.registerNamespace((String)entry.getKey(), (String)entry.getValue());
                    ++i;
                }
            }
            List nodes = ctx.selectNodes(xpath);
            return nodes.toArray(new Node[nodes.size()]);
        }
        catch (Exception exception) {
            return new Node[0];
        }
    }

    public static String nodeToXML(Node node) {
        StringWriter writer = new StringWriter();
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.transform(new DOMSource(node), new StreamResult(writer));
            String value = writer.toString();
            value = value.substring(value.indexOf("?>") + 2);
            return value;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return node.toString();
        }
    }
}

