/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amateras.air.util;

import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class UIUtil {
    public static Label createLabel(String text, Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(text);
        return label;
    }

    public static GridData createGridData(int span) {
        GridData gd = new GridData(768);
        gd.horizontalSpan = span;
        return gd;
    }

    public static Button createBrowseFileButton(final Text text, Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("Browse...");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                FileDialog dialog = new FileDialog(text.getShell(), 4);
                File file = new File(text.getText());
                dialog.setFilterPath(file.getParent());
                dialog.setFileName(file.getName());
                String result = dialog.open();
                if (result != null) {
                    text.setText(result);
                }
            }
        });
        return button;
    }

    public static IProject browseProject() {
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dialog.setInput((Object)ResourcesPlugin.getWorkspace());
        dialog.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return element instanceof IProject;
            }
        });
        dialog.setAllowMultiple(false);
        dialog.setTitle("Select Project");
        if (dialog.open() == 0) {
            IProject project = (IProject)dialog.getFirstResult();
            return project;
        }
        return null;
    }

    public static void openErrorDialogSub(String message) {
        Shell shell = DebugUIPlugin.getShell();
        if (shell == null) {
            DebugUIPlugin.logErrorMessage((String)message);
            return;
        }
        MessageDialog.openError((Shell)shell, (String)"ERROR", (String)message);
    }

    public static void openErrorDialog(final String message) {
        Display display = DebugUIPlugin.getStandardDisplay();
        if (display.getThread().equals(Thread.currentThread())) {
            UIUtil.openErrorDialogSub(message);
        }
        Runnable r = new Runnable(){

            public void run() {
                UIUtil.openErrorDialogSub(message);
            }
        };
        DebugUIPlugin.getStandardDisplay().syncExec(r);
    }

    public static IEditorPart getActiveEditor() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        IEditorPart editorPart = page.getActiveEditor();
        return editorPart;
    }
}

