/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amateras.air.util;

import java.io.File;
import java.io.IOException;
import net.sf.amateras.air.AIRPlugin;
import net.sf.amateras.air.util.UIUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.jface.preference.IPreferenceStore;

public class ProcessUtil {
    public static Process createProcess(File executeFile, File currentDir) throws IOException {
        String executePath = executeFile.getAbsolutePath();
        System.out.println(executePath);
        return Runtime.getRuntime().exec(executePath, null, currentDir);
    }

    public static Process createProcess(File executeFile, String[] commands, File currentDir) throws IOException {
        String executePath = executeFile.getAbsolutePath();
        String[] newCommand = new String[commands.length + 1];
        newCommand[0] = executePath;
        int i = 1;
        while (i < commands.length + 1) {
            newCommand[i] = commands[i - 1];
            ++i;
        }
        return Runtime.getRuntime().exec(newCommand, null, currentDir);
    }

    public static boolean checkAirGearProject(IProject project) {
        boolean isNotAirGearProject = false;
        try {
            if (!project.hasNature("net.sf.amateras.air.AIRHTMLProjectNature") && !project.hasNature("net.sf.amateras.air.AIRFlexProjectNature")) {
                isNotAirGearProject = true;
            }
        }
        catch (CoreException coreException) {
            isNotAirGearProject = true;
        }
        if (isNotAirGearProject) {
            UIUtil.openErrorDialog(AIRPlugin.getResourceString("NOT_AIRGEAR_PROJECT"));
            return false;
        }
        return true;
    }

    public static String getAirSdkPath() {
        IPreferenceStore store = AIRPlugin.getDefault().getPreferenceStore();
        String sdkPath = store.getString("flexSdkPath");
        if (sdkPath.length() == 0 && (sdkPath = store.getString("airSdkPath")).length() == 0) {
            return null;
        }
        return sdkPath;
    }

    public static String getAirSdkPath(String needfilePath) {
        File adl;
        IPreferenceStore store = AIRPlugin.getDefault().getPreferenceStore();
        String flexSdkPath = store.getString("flexSdkPath");
        String airSdkPath = store.getString("airSdkPath");
        if (flexSdkPath.length() != 0 && (adl = new File(flexSdkPath, needfilePath)).exists()) {
            return flexSdkPath;
        }
        if (airSdkPath.length() != 0 && (adl = new File(airSdkPath, needfilePath)).exists()) {
            return airSdkPath;
        }
        UIUtil.openErrorDialog(AIRPlugin.getResourceString("NOT_SDK_SETTING"));
        DebugPlugin.logMessage((String)AIRPlugin.getResourceString("NOT_SDK_SETTING"), null);
        return null;
    }
}

