/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amateras.air.util;

import java.util.HashMap;
import java.util.Map;
import net.sf.amateras.air.AIRPlugin;
import net.sf.amateras.air.mxml.models.AbstractComponentModel;
import org.eclipse.draw2d.IFigure;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;

public class FontManager {
    private Map<FontData, Font> fonts = new HashMap<FontData, Font>();

    public Font getFont(String name, int height, int style) {
        return this.getFont(new FontData(name, height, style));
    }

    public Font getFont(FontData fontData) {
        Font font = this.fonts.get(fontData);
        if (font == null) {
            font = new Font(null, fontData);
            this.fonts.put(fontData, font);
        }
        return font;
    }

    public void setFont(AbstractComponentModel model, IFigure figure) {
        Font font;
        String fontFamily = model.getAttributeToString("fontFamily");
        int fontSize = 10;
        if (model.getAttribute("fontSize") != null) {
            try {
                fontSize = model.getAttributeToNumber("fontSize");
                int mattingSize = AIRPlugin.getDefault().getPreferenceStore().getInt("fontMattingSize");
                if (mattingSize != 0 && fontSize + mattingSize > 0) {
                    fontSize += mattingSize;
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
        String fontStyle = model.getAttributeToString("fontStyle");
        String fontWeight = model.getAttributeToString("fontWeight");
        int style = 0;
        if (fontStyle != null && fontStyle.equals("italic")) {
            style = 2;
        } else if (fontWeight != null && fontWeight.equals("bold")) {
            style = 1;
        }
        if (fontFamily == null) {
            fontFamily = "Verdana";
        }
        if ((font = AIRPlugin.getDefault().getFontManager().getFont(fontFamily, fontSize, style)) != figure.getFont()) {
            figure.setFont(font);
        }
    }

    public void dispose() {
        for (Font font : this.fonts.values()) {
            font.dispose();
        }
    }
}

