/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amateras.air.propertyPages;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.amateras.air.AIRPlugin;
import net.sf.amateras.air.builder.CompileProperty;
import net.sf.amateras.air.util.UIUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateBuildSettingDialog
extends TitleAreaDialog {
    private CompileProperty compile;
    private Text command;
    private Button mxmlType;
    private Button as3Type;
    private Button chkExtention;
    private Text options;
    private IProject project;
    private ScopedPreferenceStore store;
    private List<CheckEntry> needText = new ArrayList<CheckEntry>();
    private Map<Button, Text> optionMap = new HashMap<Button, Text>();

    public CreateBuildSettingDialog(Shell parentShell, IProject project, CompileProperty compile) {
        super(parentShell);
        this.project = project;
        this.compile = compile;
        this.store = new ScopedPreferenceStore((IScopeContext)new ProjectScope(project), "net.sf.amateras.air");
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(String.valueOf(AIRPlugin.getResourceString("BUILD_SETTING")) + " - " + this.compile.getDirectory());
        Composite area = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(area, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        composite.setLayoutData((Object)new GridData(768));
        Group groupType = new Group(composite, 0);
        groupType.setLayout((Layout)new GridLayout(2, false));
        groupType.setText(AIRPlugin.getResourceString("BUILD_TYPE"));
        groupType.setLayoutData((Object)new GridData(768));
        this.mxmlType = new Button((Composite)groupType, 16);
        this.mxmlType.setText("AIRFlex");
        this.mxmlType.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CreateBuildSettingDialog.this.setDefaultSetting(1);
            }
        });
        this.as3Type = new Button((Composite)groupType, 16);
        this.as3Type.setText("ActionScript");
        this.as3Type.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CreateBuildSettingDialog.this.setDefaultSetting(2);
            }
        });
        this.chkExtention = new Button(composite, 32);
        this.chkExtention.setText(AIRPlugin.getResourceString("ENABLE_BUILD_EXTENSION"));
        this.chkExtention.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CreateBuildSettingDialog.this.refreshExtensionState();
            }
        });
        Group group = new Group(composite, 0);
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)new GridData(1808));
        this.command = this.createText("Command", (Composite)group, true);
        this.options = this.createText("Options", (Composite)group, false);
        this.addOption("-output", (Composite)group);
        this.addOption("-library-path+=", (Composite)group);
        this.addOption("-source-path", (Composite)group);
        this.addOption("-include-classes", (Composite)group);
        this.addOption("-locale=", (Composite)group);
        this.addOption("-allow-source-path-overlap=", (Composite)group);
        return parent;
    }

    private void addOption(String key, Composite parent) {
        Button check = new Button(parent, 32);
        check.setText(key);
        Text text = new Text(parent, 2048);
        text.setLayoutData((Object)new GridData(768));
        this.optionMap.put(check, text);
    }

    private void refreshExtensionState() {
        if (this.chkExtention.getSelection()) {
            this.command.setEnabled(true);
            this.options.setEnabled(true);
            for (Button key : this.optionMap.keySet()) {
                key.setEnabled(true);
                this.optionMap.get(key).setEnabled(true);
            }
        } else {
            this.command.setEnabled(false);
            this.options.setEnabled(false);
            for (Button key : this.optionMap.keySet()) {
                key.setEnabled(false);
                this.optionMap.get(key).setEnabled(false);
            }
        }
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        if (this.compile.getCommandType() == 1) {
            this.mxmlType.setSelection(true);
        } else {
            this.as3Type.setSelection(true);
        }
        if (this.compile.isExtention()) {
            this.chkExtention.setSelection(true);
            this.setTypeContents(this.compile.getCommandType(), this.compile.getCommand(), this.compile.getOption());
        } else {
            this.chkExtention.setSelection(false);
            this.setDefaultSetting(this.compile.getCommandType());
        }
        this.setASCompVisible(this.compile.getCommandType());
        this.doValidate();
        return control;
    }

    private void setTypeContents(int type, String commandValue, String optionValue) {
        this.command.setText(commandValue);
        this.options.setText("");
        List<String> opt = CreateBuildSettingDialog.parseOption(optionValue);
        for (Button key : this.optionMap.keySet()) {
            key.setSelection(false);
            this.optionMap.get(key).setText("");
        }
        int i = 0;
        while (i < opt.size()) {
            String option = opt.get(i);
            System.out.println(String.valueOf(i) + ":" + option);
            boolean isSelected = false;
            for (Button key : this.optionMap.keySet()) {
                if (key.getText().endsWith("=")) {
                    if (!option.startsWith(key.getText())) continue;
                    key.setSelection(true);
                    this.optionMap.get(key).setText(this.replaceString(option.substring(key.getText().length())));
                    isSelected = true;
                    break;
                }
                if (!option.startsWith(String.valueOf(key.getText()) + " ") && !option.startsWith(String.valueOf(key.getText()) + "=") && !option.startsWith(String.valueOf(key.getText()) + "+=")) continue;
                key.setSelection(true);
                String value = option.substring(key.getText().length());
                if (value.startsWith(" ")) {
                    this.optionMap.get(key).setText(this.replaceString(value.substring(1)));
                } else {
                    this.optionMap.get(key).setText(this.replaceString(value));
                }
                isSelected = true;
                break;
            }
            if (!isSelected) {
                if (this.options.getText().length() > 0) {
                    this.options.setText(String.valueOf(this.options.getText()) + " " + this.replaceString(option));
                } else {
                    this.options.setText(this.replaceString(option));
                }
            }
            ++i;
        }
        this.refreshExtensionState();
    }

    protected static List<String> parseOption(String value) {
        ArrayList<String> list = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        char[] chars = value.toCharArray();
        int i = 0;
        while (i < chars.length) {
            if (i >= chars.length - 1) {
                sb.append(chars[i]);
                list.add(sb.toString());
                sb = new StringBuilder();
            } else if (chars[i] == '-') {
                if (chars[i + 1] == '-') {
                    sb.append(chars[i]);
                    sb.append(chars[i + 1]);
                    if (sb.length() != 0) {
                        list.add(sb.toString());
                        sb = new StringBuilder();
                    }
                    ++i;
                } else {
                    sb.append(chars[i]);
                }
            } else if (chars[i] == ' ') {
                if (chars[i + 1] == '-' || chars[i + 1] == '+') {
                    if (chars[i + 1] == '-' && i < chars.length - 2 && chars[i + 2] == '-') {
                        sb.append(chars[i]);
                        sb.append(chars[i + 1]);
                        sb.append(chars[i + 2]);
                        if (sb.length() != 0) {
                            list.add(sb.toString());
                            sb = new StringBuilder();
                        }
                        ++i;
                        ++i;
                    } else {
                        if (sb.length() != 0) {
                            list.add(sb.toString());
                            sb = new StringBuilder();
                        }
                        sb.append(chars[i + 1]);
                        ++i;
                    }
                } else {
                    sb.append(chars[i]);
                }
            } else {
                sb.append(chars[i]);
            }
            ++i;
        }
        return list;
    }

    public static void main(String[] args) {
        List<String> list = CreateBuildSettingDialog.parseOption("+configname=air flextest.mxml -output flextest.swf -library-path+=${LIBRARY_PATH}, 2 -souce-path aaa bbb ccc -- -nextOption");
        for (String l : list) {
            System.out.println(l);
        }
    }

    private void setDefaultSetting(int type) {
        if (type == 1) {
            this.setTypeContents(this.compile.getCommandType(), this.store.getDefaultString("flexCompileCommand"), this.store.getDefaultString("flexCompileCommandOption"));
        } else {
            this.setTypeContents(this.compile.getCommandType(), this.store.getDefaultString("as3CompileCommand"), this.store.getDefaultString("as3CompileCommandOption"));
        }
        this.setASCompVisible(type);
    }

    private void setASCompVisible(int type) {
    }

    protected void okPressed() {
        if (this.mxmlType.getSelection()) {
            this.compile.setCommandType(1);
        } else {
            this.compile.setCommandType(2);
        }
        this.compile.setExtention(this.chkExtention.getSelection());
        if (this.chkExtention.getSelection()) {
            this.compile.setCommand(this.command.getText());
            StringBuilder sb = new StringBuilder();
            if (this.options.getText().length() > 0) {
                sb.append(this.options.getText()).append(" ");
            }
            for (Button key : this.optionMap.keySet()) {
                if (!key.getSelection()) continue;
                sb.append(key.getText());
                if (!(key.getText().endsWith("=") || this.optionMap.get(key).getText().startsWith("=") || this.optionMap.get(key).getText().startsWith("+="))) {
                    sb.append(" ");
                }
                sb.append(this.optionMap.get(key).getText()).append(" ");
            }
            this.compile.setOption(sb.toString().trim());
        } else if (this.compile.getCommandType() == 1) {
            this.compile.setCommand(this.store.getDefaultString("flexCompileCommand"));
            this.compile.setOption(this.store.getDefaultString("flexCompileCommandOption"));
        } else {
            this.compile.setCommand(this.store.getDefaultString("as3CompileCommand"));
            this.compile.setOption(this.store.getDefaultString("as3CompileCommandOption"));
        }
        super.okPressed();
    }

    private Text createText(String label, Composite parent, boolean isNeed) {
        return this.createText(label, parent, isNeed, 2048);
    }

    private Text createText(String label, Composite parent, boolean isNeed, int textType) {
        UIUtil.createLabel(label, parent);
        Text text = new Text(parent, textType);
        text.setLayoutData((Object)new GridData(768));
        if (isNeed) {
            this.needText.add(new CheckEntry(text, label));
            text.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    CreateBuildSettingDialog.this.doValidate();
                }
            });
        }
        return text;
    }

    private void doValidate() {
        for (CheckEntry check : this.needText) {
            if (check.getText().getText().length() != 0) continue;
            this.setErrorMessage(this.getMessage("IS_NEED", check.getMessage()));
            this.getButton(0).setEnabled(false);
            return;
        }
        this.setErrorMessage(null);
        this.getButton(0).setEnabled(true);
    }

    private String getMessage(String key, Object ... args) {
        return AIRPlugin.getResourceString(key, args);
    }

    private String replaceString(String value) {
        try {
            value = value.replaceAll("\\$\\{PROJECT_NAME\\}", this.project.getName());
            value = value.replaceAll("\\$\\{DIRECTORY\\}", this.compile.getDirectory());
            return value;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return value;
        }
    }

    class CheckEntry {
        private Text text;
        private String message;

        CheckEntry(Text text, String message) {
            this.text = text;
            this.message = message;
        }

        public Text getText() {
            return this.text;
        }

        public void setText(Text text) {
            this.text = text;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }
    }
}

