/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amateras.air.preferences;

import net.sf.amateras.air.AIRPlugin;
import net.sf.amateras.air.util.UIUtil;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class AIRPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Text airSdkPath;
    private Text flexSdkPath;
    private Text fcshPath;
    private Text adlPath;
    private Text adtPath;

    public AIRPreferencePage() {
        super("AIR GEAR");
        this.setPreferenceStore(AIRPlugin.getDefault().getPreferenceStore());
    }

    protected Control createContents(Composite parent) {
        IPreferenceStore stote = this.getPreferenceStore();
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(1808));
        this.airSdkPath = this.addButtonPath(composite, "AIR SDK:");
        this.airSdkPath.setText(stote.getString("airSdkPath"));
        this.flexSdkPath = this.addButtonPath(composite, "Flex SDK:");
        this.flexSdkPath.setText(stote.getString("flexSdkPath"));
        Group groupPath = new Group(parent, 0);
        groupPath.setLayout((Layout)new GridLayout(2, false));
        groupPath.setLayoutData((Object)new GridData(768));
        this.adlPath = this.addRelatedPath((Composite)groupPath, "ADL:", "Flex SDK/");
        this.adlPath.setText(stote.getString("adlCommand"));
        this.adtPath = this.addRelatedPath((Composite)groupPath, "ADT:", "Flex SDK/");
        this.adtPath.setText(stote.getString("adtCommand"));
        this.fcshPath = this.addRelatedPath((Composite)groupPath, "FCSH:", "Flex SDK/");
        this.fcshPath.setText(stote.getString("fcshShellCommand"));
        return composite;
    }

    private Text addButtonPath(Composite parent, String label) {
        UIUtil.createLabel(label, parent);
        Composite composite2 = new Composite(parent, 0);
        composite2.setLayout((Layout)new GridLayout(2, false));
        composite2.setLayoutData((Object)new GridData(768));
        final Text text = new Text(composite2, 2048);
        text.setLayoutData((Object)new GridData(768));
        Button browse = new Button(composite2, 8);
        browse.setText("Browse...");
        browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(AIRPreferencePage.this.getShell());
                String result = dialog.open();
                if (result != null) {
                    text.setText(result);
                }
            }
        });
        return text;
    }

    private Text addRelatedPath(Composite parent, String label, String parentLabel) {
        UIUtil.createLabel(label, parent);
        Composite composite2 = new Composite(parent, 0);
        composite2.setLayout((Layout)new GridLayout(2, false));
        composite2.setLayoutData((Object)new GridData(768));
        UIUtil.createLabel(parentLabel, composite2);
        Text text = new Text(composite2, 2048);
        text.setLayoutData((Object)new GridData(768));
        return text;
    }

    public void init(IWorkbench workbench) {
    }

    protected void performDefaults() {
        IPreferenceStore stote = this.getPreferenceStore();
        this.airSdkPath.setText(stote.getDefaultString("airSdkPath"));
        this.flexSdkPath.setText(stote.getDefaultString("flexSdkPath"));
        this.fcshPath.setText(stote.getDefaultString("fcshShellCommand"));
        this.adlPath.setText(stote.getDefaultString("adlCommand"));
        this.adtPath.setText(stote.getDefaultString("adtCommand"));
        super.performDefaults();
    }

    public boolean performOk() {
        IPreferenceStore stote = this.getPreferenceStore();
        stote.setValue("airSdkPath", this.airSdkPath.getText());
        stote.setValue("flexSdkPath", this.flexSdkPath.getText());
        stote.setValue("fcshShellCommand", this.fcshPath.getText());
        stote.setValue("adlCommand", this.adlPath.getText());
        stote.setValue("adtCommand", this.adtPath.getText());
        return true;
    }
}

