/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amateras.air.preferences;

import net.sf.amateras.air.AIRPlugin;
import net.sf.amateras.air.util.UIUtil;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class AIRCompilePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Text compileMessage;
    private Text compileFailPattern;
    private Text compileErrorPattern;
    private Text compileWarningPattern;
    private Text compileFailPattern2;
    private Text compileErrorPattern2;
    private Text compileWarningPattern2;
    private Button isAddInfoMarker;

    public AIRCompilePreferencePage() {
        super("AIR GEAR - Compile Option");
        this.setPreferenceStore(AIRPlugin.getDefault().getPreferenceStore());
    }

    protected Control createContents(Composite parent) {
        IPreferenceStore stote = this.getPreferenceStore();
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        composite.setLayoutData((Object)new GridData(1808));
        Group group = new Group(composite, 0);
        group.setText(AIRPlugin.getResourceString("COMPILE_MATCH_PATTERN"));
        group.setLayout((Layout)new GridLayout(1, false));
        group.setLayoutData((Object)new GridData(768));
        Composite composite2 = new Composite((Composite)group, 0);
        composite2.setLayout((Layout)new GridLayout(2, false));
        composite2.setLayoutData((Object)new GridData(1808));
        this.compileMessage = this.addText(composite2, "ID");
        this.compileMessage.setText(stote.getString("compileMessagePattern"));
        Group gerror = new Group((Composite)group, 0);
        gerror.setLayout((Layout)new GridLayout(2, false));
        gerror.setLayoutData((Object)new GridData(768));
        this.compileErrorPattern = this.addText((Composite)gerror, "Error");
        this.compileErrorPattern.setText(stote.getString("compileErrorPattern"));
        this.compileErrorPattern2 = this.addText((Composite)gerror, "Error(2)");
        this.compileErrorPattern2.setText(stote.getString("compileErrorPattern2"));
        Group gwarn = new Group((Composite)group, 0);
        gwarn.setLayout((Layout)new GridLayout(2, false));
        gwarn.setLayoutData((Object)new GridData(768));
        this.compileWarningPattern = this.addText((Composite)gwarn, "Warnig");
        this.compileWarningPattern.setText(stote.getString("compileWarningPattern"));
        this.compileWarningPattern2 = this.addText((Composite)gwarn, "Warnig(2)");
        this.compileWarningPattern2.setText(stote.getString("compileWarningPattern2"));
        Group gfail = new Group((Composite)group, 0);
        gfail.setLayout((Layout)new GridLayout(2, false));
        gfail.setLayoutData((Object)new GridData(768));
        this.compileFailPattern = this.addText((Composite)gfail, "Failure");
        this.compileFailPattern.setText(stote.getString("compileFailPattern"));
        this.compileFailPattern2 = this.addText((Composite)gfail, "Failure(2)");
        this.compileFailPattern2.setText(stote.getString("compileFailPattern2"));
        this.isAddInfoMarker = new Button(composite, 32);
        this.isAddInfoMarker.setText(AIRPlugin.getResourceString("COMPILE_IS_ADD_INFO_MARKER"));
        this.isAddInfoMarker.setSelection(stote.getBoolean("isAddMarkerCompileInfo"));
        return composite;
    }

    private Text addText(Composite parent, String label) {
        UIUtil.createLabel(label, parent);
        Text text = new Text(parent, 2048);
        text.setLayoutData((Object)new GridData(768));
        return text;
    }

    public void init(IWorkbench workbench) {
    }

    protected void performDefaults() {
        IPreferenceStore stote = this.getPreferenceStore();
        this.compileMessage.setText(stote.getDefaultString("compileMessagePattern"));
        this.compileErrorPattern.setText(stote.getDefaultString("compileErrorPattern"));
        this.compileWarningPattern.setText(stote.getDefaultString("compileWarningPattern"));
        this.compileFailPattern.setText(stote.getDefaultString("compileFailPattern"));
        this.compileErrorPattern2.setText(stote.getDefaultString("compileErrorPattern2"));
        this.compileWarningPattern2.setText(stote.getDefaultString("compileWarningPattern2"));
        this.compileFailPattern2.setText(stote.getDefaultString("compileFailPattern2"));
        this.isAddInfoMarker.setSelection(stote.getDefaultBoolean("isAddMarkerCompileInfo"));
        super.performDefaults();
    }

    public boolean performOk() {
        IPreferenceStore stote = this.getPreferenceStore();
        stote.setValue("compileMessagePattern", this.compileMessage.getText());
        stote.setValue("compileErrorPattern", this.compileErrorPattern.getText());
        stote.setValue("compileWarningPattern", this.compileWarningPattern.getText());
        stote.setValue("compileFailPattern", this.compileFailPattern.getText());
        stote.setValue("compileErrorPattern2", this.compileErrorPattern2.getText());
        stote.setValue("compileWarningPattern2", this.compileWarningPattern2.getText());
        stote.setValue("compileFailPattern2", this.compileFailPattern2.getText());
        stote.setValue("isAddMarkerCompileInfo", this.isAddInfoMarker.getSelection());
        return true;
    }
}

