/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amateras.air.mxml.models;

import net.sf.amateras.air.mxml.models.AbstractContainerModel;
import net.sf.amateras.air.mxml.models.IComponentModel;
import net.sf.amateras.air.mxml.models.ISelectedView;

public class ViewStackModel
extends AbstractContainerModel
implements ISelectedView {
    public static final String COMPONENT_NAME = "ViewStack";
    public static final String HISTORY_MANAGEMENT_ENABLED = "historyManagementEnabled";
    public static final String RESIZE_TO_CONTENT = "resizeToContent";
    public static final String SELECTED_INDEX = "selectedIndex";
    public static final String HORIZONTAL_GAP = "horizontalGap";
    public static final String PADDING_BOTTOM = "paddingBottom";
    public static final String PADDING_TOP = "paddingTop";
    public static final String VERTICAL_GAP = "verticalGap";
    private int selectedIndex = -1;

    protected void installModelProperty() {
        super.installModelProperty();
        this.addBooleanModelProperty(HISTORY_MANAGEMENT_ENABLED, "Properties", false);
        this.addBooleanModelProperty(RESIZE_TO_CONTENT, "Properties", false);
        this.addNumberModelProperty(SELECTED_INDEX, "Properties", 0);
        this.addNumberModelProperty(HORIZONTAL_GAP, "Styles", 8);
        this.addNumberModelProperty(PADDING_BOTTOM, "Styles", 0);
        this.addNumberModelProperty(PADDING_TOP, "Styles", 0);
        this.addNumberModelProperty(VERTICAL_GAP, "Styles", 6);
    }

    public void removeChild(IComponentModel child) {
        int removeIndex = this.getChildIndex(child);
        super.removeChild(child);
        if (removeIndex == this.selectedIndex) {
            if (this.selectedIndex < this.getChildren().size()) {
                this.setSelectedIndex(this.selectedIndex);
            } else {
                this.setSelectedIndex(-1);
            }
        }
    }

    protected String getComponentName() {
        return COMPONENT_NAME;
    }

    public void setSelectedIndex(int selectedIndex) {
        this.selectedIndex = selectedIndex;
        this.fireChildPropertyChange();
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }
}

