/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amateras.air.mxml.models;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sf.amateras.air.mxml.descriptor.ColorChoosePropertyDescriptor;
import net.sf.amateras.air.mxml.descriptor.IEditorValueDescriptor;
import net.sf.amateras.air.mxml.descriptor.ImagePropertyDescriptor;
import net.sf.amateras.air.mxml.descriptor.StringListPropertyDescriptor;
import net.sf.amateras.air.mxml.descriptor.StringPropertyDescriptor;
import net.sf.amateras.air.mxml.descriptor.WidthHeightPropertyDescriptor;
import net.sf.amateras.air.mxml.models.IModel;
import net.sf.amateras.air.mxml.models.ModelProperty;
import net.sf.amateras.air.mxml.models.PropertyManager;
import net.sf.amateras.air.util.ColorUtil;
import net.sf.amateras.air.util.XMLUtil;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractModel
implements IModel,
IPropertySource {
    public static String NULL_PROPERTY = "";
    private Map<Object, ModelProperty> properties;
    private PropertyChangeSupport listeners = new PropertyChangeSupport(this);
    private Map<Object, Object> propertyAttributes = new LinkedHashMap<Object, Object>();
    private Map additionalAttributes = new HashMap();
    private List<Element> additionalChildElements = new ArrayList<Element>();
    private static String[] LIST_BOOLEAN = new String[]{"true", "false"};

    public AbstractModel() {
        this.properties = PropertyManager.getProperties(this.getClass().getName());
        if (this.properties == null) {
            this.properties = new HashMap<Object, ModelProperty>();
            this.installModelProperty();
            PropertyManager.putProperties(this.getClass().getName(), this.properties);
        }
    }

    protected void installModelProperty() {
        this.addStringModelProperty("id", "Properties", null);
    }

    @Override
    public void setAdditionalAttributes(Map additionalAttributes) {
        this.additionalAttributes = additionalAttributes;
    }

    @Override
    public Map getAdditionalAttributes() {
        return this.additionalAttributes;
    }

    @Override
    public void addAdditionalChildElement(Element childNode) {
        this.additionalChildElements.add(childNode);
    }

    @Override
    public List<Element> getAdditionalChildElements() {
        return this.additionalChildElements;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.addPropertyChangeListener(listener);
    }

    public void firePropertyChange(String propName, Object oldValue, Object newValue) {
        this.listeners.firePropertyChange(propName, oldValue, newValue);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.removePropertyChangeListener(listener);
    }

    protected void addModelProperty(Object id, ModelProperty property) {
        this.properties.put(id, property);
    }

    public ModelProperty getModelProperty(Object id) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(id);
    }

    @Override
    public Map getModelProperties() {
        return this.properties;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        ArrayList<IPropertyDescriptor> descriptors = new ArrayList<IPropertyDescriptor>();
        for (ModelProperty property : this.properties.values()) {
            IPropertyDescriptor descriptor = property.getDescriptor();
            if (descriptor == null) continue;
            descriptors.add(descriptor);
        }
        return descriptors.toArray(new IPropertyDescriptor[descriptors.size()]);
    }

    public Object getPropertyValue(Object id) {
        if (this.getModelProperty(id) == null) {
            return null;
        }
        Object prop = this.propertyAttributes.get(id);
        if (prop == null) {
            IPropertyDescriptor descriptor = this.getModelProperty(id).getDescriptor();
            if (descriptor instanceof ColorChoosePropertyDescriptor) {
                return ((ColorChoosePropertyDescriptor)descriptor).getDefaultValue();
            }
            return NULL_PROPERTY;
        }
        return prop;
    }

    public Object getRealPropertyValue(Object id) {
        if (this.getModelProperty(id) == null) {
            return null;
        }
        IPropertyDescriptor descriptor = this.getModelProperty(id).getDescriptor();
        if (descriptor instanceof IEditorValueDescriptor) {
            try {
                return ((IEditorValueDescriptor)descriptor).getEditorValue(this.propertyAttributes.get(id));
            }
            catch (Exception ex) {
                System.err.println("UnMatch DataType. model=" + this + ",id=" + id + ", value=" + this.propertyAttributes.get(id).getClass());
                ex.printStackTrace();
            }
        }
        return this.propertyAttributes.get(id);
    }

    public boolean isDefaultValue(Object id, Object value) {
        Object defaultValue;
        if (value == null) {
            return true;
        }
        IPropertyDescriptor descriptor = this.getModelProperty(id).getDescriptor();
        return descriptor instanceof IEditorValueDescriptor && value.equals(defaultValue = ((IEditorValueDescriptor)descriptor).getDefaultValue());
    }

    public boolean isPropertySet(Object id) {
        return this.properties.containsKey(id);
    }

    @Override
    public void resetPropertyValue(Object id) {
        this.propertyAttributes.remove(id);
    }

    @Override
    public void setPropertyValue(Object id, Object value) {
        this.setPropertyValue(id, value, true);
    }

    public void setPropertyValue(Object id, Object value, boolean isFirePropertyChange) {
        if (value == null || value.equals(NULL_PROPERTY) || value.toString().length() == 0) {
            this.resetPropertyValue(id);
            return;
        }
        Object oldValue = this.propertyAttributes.get(id);
        this.propertyAttributes.put(id, value);
        if (isFirePropertyChange) {
            this.firePropertyChange(id.toString(), oldValue, value);
        }
    }

    public Object getEditableValue() {
        return this;
    }

    private boolean isLayoutKey(Object id) {
        return id.equals("_x") || id.equals("_y") || id.equals("_width") || id.equals("_height");
    }

    protected String getAttributesXML() {
        StringBuilder sb = new StringBuilder();
        StringBuilder layoutInfos = new StringBuilder();
        for (String key : this.getPropertyAttributes().keySet()) {
            if (!this.isOutputAtribute(key.substring(1))) continue;
            if (this.isLayoutKey(key)) {
                this.addAttributeXml(layoutInfos, key);
                continue;
            }
            this.addAttributeXml(sb, key);
        }
        sb.append(layoutInfos.toString());
        return sb.toString();
    }

    protected boolean isOutputAtribute(String propertyName) {
        return true;
    }

    private void addAttributeXml(StringBuilder sb, String key) {
        Object value = this.getPropertyAttributes().get(key);
        if (value != null) {
            if (value instanceof RGB) {
                sb.append(" ").append(key.substring(1)).append("=\"");
                sb.append(ColorUtil.toHex((RGB)value)).append("\"");
            } else if (value.toString().length() != 0) {
                sb.append(" ").append(key.substring(1)).append("=\"");
                sb.append(XMLUtil.escape(value.toString())).append("\"");
            }
        }
    }

    protected String getAdditionalAttributesXML() {
        StringBuffer sb = new StringBuffer();
        for (Map.Entry entry : this.additionalAttributes.entrySet()) {
            sb.append(" ");
            sb.append((String)entry.getKey());
            sb.append("=\"");
            sb.append(XMLUtil.escape((String)entry.getValue()));
            sb.append("\"");
        }
        return sb.toString();
    }

    protected String getAdditionalChildElementsXML() {
        StringBuilder sb = new StringBuilder();
        if (this.additionalChildElements.size() != 0) {
            Iterator<Element> ite = this.additionalChildElements.iterator();
            while (ite.hasNext()) {
                sb.append(XMLUtil.nodeToXML(ite.next()));
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public abstract String toMXML();

    protected void addStringModelProperty(String propertyName, String category, String defaultValue) {
        this.addModelProperty("_" + propertyName, new ModelProperty(propertyName, (PropertyDescriptor)new StringPropertyDescriptor("_" + propertyName, propertyName, defaultValue), category));
    }

    protected void addStringModelProperty(String propertyName, String category) {
        this.addStringModelProperty(propertyName, category, null);
    }

    protected void addBooleanModelProperty(String propertyName, String category, boolean defaultValue) {
        this.addListModelProperty(propertyName, category, LIST_BOOLEAN, String.valueOf(defaultValue));
    }

    protected void addNumberModelProperty(String propertyName, String category, Integer defaultValue) {
        this.addModelProperty("_" + propertyName, new ModelProperty(propertyName, (PropertyDescriptor)new StringPropertyDescriptor("_" + propertyName, propertyName, defaultValue == null ? "" : String.valueOf(defaultValue)), category));
    }

    protected void addNumberModelProperty(String propertyName, String category) {
        this.addNumberModelProperty(propertyName, category, null);
    }

    protected void addWidthHeightModelProperty(String propertyName, String category, String defaultValue) {
        this.addModelProperty("_" + propertyName, new ModelProperty(propertyName, (PropertyDescriptor)new WidthHeightPropertyDescriptor("_" + propertyName, propertyName, String.valueOf(defaultValue)), category));
    }

    protected void addDoubleModelProperty(String propertyName, String category, Double defaultValue) {
        if (defaultValue == null) {
            this.addModelProperty("_" + propertyName, new ModelProperty(propertyName, (PropertyDescriptor)new StringPropertyDescriptor("_" + propertyName, propertyName, null), category));
        } else {
            this.addModelProperty("_" + propertyName, new ModelProperty(propertyName, (PropertyDescriptor)new StringPropertyDescriptor("_" + propertyName, propertyName, String.valueOf(defaultValue)), category));
        }
    }

    protected void addColorModelProperty(String propertyName, String category, RGB defaultValue) {
        this.addModelProperty("_" + propertyName, new ModelProperty(propertyName, (PropertyDescriptor)new ColorChoosePropertyDescriptor("_" + propertyName, propertyName, defaultValue), category));
    }

    protected void addColorModelProperty(String propertyName, String category) {
        this.addColorModelProperty(propertyName, category, null);
    }

    protected void addImageModelProperty(String propertyName, String category, String defaultValue) {
        this.addModelProperty("_" + propertyName, new ModelProperty(propertyName, new ImagePropertyDescriptor("_" + propertyName, propertyName, defaultValue), category));
    }

    protected void addImageModelProperty(String propertyName, String category) {
        this.addImageModelProperty(propertyName, category, null);
    }

    protected void addListModelProperty(String propertyName, String category, String[] list) {
        this.addModelProperty("_" + propertyName, new ModelProperty(propertyName, (PropertyDescriptor)new StringListPropertyDescriptor("_" + propertyName, propertyName, list), category));
    }

    protected void addListModelProperty(String propertyName, String category, String[] list, String defaultValue) {
        this.addModelProperty("_" + propertyName, new ModelProperty(propertyName, (PropertyDescriptor)new StringListPropertyDescriptor("_" + propertyName, propertyName, list, defaultValue), category));
    }

    protected void addListModelProperty(String propertyName, String category) {
        this.addListModelProperty(propertyName, category, null);
    }

    protected void removePropertySheet(String propertyName) {
        ModelProperty mp = this.getModelProperty("_" + propertyName);
        mp.setDescriptor(null);
    }

    public Map getPropertyAttributes() {
        return this.propertyAttributes;
    }

    public void setAttribute(String propertyName, Object value) {
        this.setPropertyValue("_" + propertyName, value);
    }

    @Override
    public Object getAttribute(String propertyName) {
        Object value = this.getRealPropertyValue("_" + propertyName);
        return value;
    }

    @Override
    public String getAttributeToString(String propertyName) {
        Object value = this.getRealPropertyValue("_" + propertyName);
        if (value == null) {
            return "";
        }
        return value.toString();
    }

    public int getAttributeToNumber(String propertyName) {
        Object value = this.getRealPropertyValue("_" + propertyName);
        return Integer.parseInt(value.toString());
    }
}

