/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amateras.air.mxml.figures.layouts;

import net.sf.amateras.air.mxml.figures.ContainerFigure;
import net.sf.amateras.air.mxml.figures.IFlexRectangleFigure;
import net.sf.amateras.air.mxml.models.FlexRectangle;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Transposer;

public class SizeLibrary {
    public static Dimension getUseSize(IFigure figure, int wHint, int hHint) {
        Dimension realSize = null;
        Dimension calcSize = SizeLibrary.getCalculateUseSize(figure, wHint, hHint);
        if (calcSize.width == -1) {
            realSize = SizeLibrary.getRealSize(figure, wHint, hHint);
            calcSize.width = realSize.width;
        }
        if (calcSize.height == -1) {
            if (realSize == null) {
                realSize = SizeLibrary.getRealSize(figure, wHint, hHint);
            }
            calcSize.height = realSize.height;
        }
        return calcSize;
    }

    private static Dimension getCalculateUseSize(IFigure figure, int wHint, int hHint) {
        int width = -1;
        int height = -1;
        Dimension defaultSize = null;
        if (figure instanceof IFlexRectangleFigure) {
            int percent;
            FlexRectangle rec = ((IFlexRectangleFigure)figure).getRectangle();
            if (rec == null) {
                rec = new FlexRectangle();
                ((IFlexRectangleFigure)figure).setRectangle(rec);
            }
            width = rec.width;
            height = rec.height;
            if (width == -1) {
                if (rec.getStrWidth().length() == 0) {
                    defaultSize = SizeLibrary.getDefaultSize(figure, wHint, hHint);
                    width = defaultSize.width;
                } else if (!rec.getStrWidth().endsWith("%")) {
                    width = Integer.parseInt(rec.getStrWidth());
                } else {
                    percent = Integer.parseInt(rec.getStrWidth().substring(0, rec.getStrWidth().length() - 1));
                    width = SizeLibrary.getParentRealWidth(figure, wHint, 100);
                    if (width <= 0 && wHint > 0) {
                        width = wHint;
                    }
                    if (width > 0) {
                        width = width * percent / 100;
                    }
                }
            }
            if (height == -1) {
                if (rec.getStrHeight().length() == 0) {
                    if (defaultSize == null) {
                        defaultSize = SizeLibrary.getDefaultSize(figure, wHint, hHint);
                    }
                    height = defaultSize.height;
                } else if (!rec.getStrHeight().endsWith("%")) {
                    height = Integer.parseInt(rec.getStrHeight());
                } else {
                    percent = Integer.parseInt(rec.getStrHeight().substring(0, rec.getStrHeight().length() - 1));
                    height = SizeLibrary.getParentRealHeight(figure, hHint, 100);
                    if (height <= 0 && hHint > 0) {
                        height = hHint;
                    }
                    if (height > 0) {
                        height = height * percent / 100;
                    }
                }
            }
        }
        return new Dimension(width, height);
    }

    private static int getParentRealWidth(IFigure figure, int wHint, int percent) {
        if (figure.getParent() == null) {
            return -1;
        }
        if (figure.getParent() instanceof IFlexRectangleFigure) {
            FlexRectangle rec = ((IFlexRectangleFigure)figure.getParent()).getRectangle();
            if (rec.width != -1) {
                return rec.width * percent / 100;
            }
            if (rec.getStrWidth().length() != 0) {
                if (rec.getStrWidth().endsWith("%")) {
                    percent = percent * Integer.parseInt(rec.getStrWidth().substring(0, rec.getStrWidth().length() - 1)) / 100;
                    return SizeLibrary.getParentRealWidth(figure.getParent(), wHint, percent);
                }
                return Integer.parseInt(rec.getStrWidth()) * percent / 100;
            }
        }
        return -1;
    }

    private static int getParentRealHeight(IFigure figure, int hHint, int percent) {
        if (figure.getParent() == null) {
            return -1;
        }
        if (figure.getParent() instanceof IFlexRectangleFigure) {
            FlexRectangle rec = ((IFlexRectangleFigure)figure.getParent()).getRectangle();
            if (rec.height != -1) {
                return rec.height * percent / 100;
            }
            if (rec.getStrHeight().length() != 0) {
                if (rec.getStrHeight().endsWith("%")) {
                    percent = percent * Integer.parseInt(rec.getStrHeight().substring(0, rec.getStrHeight().length() - 1)) / 100;
                    return SizeLibrary.getParentRealHeight(figure.getParent(), hHint, percent);
                }
                return Integer.parseInt(rec.getStrHeight()) * percent / 100;
            }
        }
        return -1;
    }

    private static Dimension getDefaultSize(IFigure figure, int wHint, int hHint) {
        if (figure instanceof Label) {
            return figure.getPreferredSize(wHint, hHint);
        }
        if (figure instanceof IFlexRectangleFigure) {
            int width = ((IFlexRectangleFigure)figure).getDefaultWidth();
            int height = ((IFlexRectangleFigure)figure).getDefaultHeight();
            return new Dimension(width, height);
        }
        return new Dimension(10, 10);
    }

    private static Dimension getRealSize(IFigure figure, int wHint, int hHint) {
        if (figure instanceof Label) {
            return figure.getPreferredSize(wHint, hHint);
        }
        if (figure instanceof IFlexRectangleFigure && !(figure instanceof ContainerFigure)) {
            int width = ((IFlexRectangleFigure)figure).getDefaultWidth();
            int height = ((IFlexRectangleFigure)figure).getDefaultHeight();
            return new Dimension(width, height);
        }
        if (figure.getLayoutManager() instanceof XYLayout) {
            return SizeLibrary.getChildrenRealSize4XYLayout(figure);
        }
        if (figure.getLayoutManager() instanceof ToolbarLayout) {
            return SizeLibrary.getChildrenRealSize4ToolbarLayout(figure, wHint, hHint);
        }
        return SizeLibrary.getChildrenRealSize4XYLayout(figure);
    }

    private static Dimension getCalculateAndDefaultSize(IFigure figure, int wHint, int hHint) {
        Dimension d = SizeLibrary.getCalculateUseSize(figure, -1, -1);
        Dimension defaultSize = SizeLibrary.getRealSize(figure, -1, -1);
        int width = d.width;
        int height = d.height;
        if (width == -1) {
            width = defaultSize.width;
        }
        if (height == -1) {
            height = defaultSize.height;
        }
        return new Dimension(width, height);
    }

    private static Dimension getChildrenRealSize4XYLayout(IFigure figure) {
        int width = 0;
        int height = 0;
        int i = 0;
        while (i < figure.getChildren().size()) {
            Rectangle rec;
            IFigure child = (IFigure)figure.getChildren().get(i);
            Dimension d = SizeLibrary.getCalculateAndDefaultSize(child, -1, -1);
            int subWidth = d.width;
            int subHeight = d.height;
            if (child instanceof IFlexRectangleFigure) {
                rec = ((IFlexRectangleFigure)child).getRectangle();
                if (rec.x > 0) {
                    subWidth += rec.x;
                }
                if (rec.y > 0) {
                    subHeight += rec.y;
                }
            } else {
                rec = child.getBounds();
                if (rec.x > 0) {
                    subWidth += rec.x;
                }
                if (rec.y > 0) {
                    subHeight += rec.y;
                }
            }
            if (width < subWidth) {
                width = subWidth;
            }
            if (height < subHeight) {
                height = subHeight;
            }
            ++i;
        }
        return new Dimension(width, height);
    }

    private static Dimension getChildrenRealSize4ToolbarLayout(IFigure figure, int wHint, int hHint) {
        int width = 0;
        int height = 0;
        boolean isHorizontal = ((ToolbarLayout)figure.getLayoutManager()).isHorizontal();
        Insets insets = figure.getInsets();
        if (isHorizontal) {
            wHint = -1;
            if (hHint >= 0) {
                hHint = Math.max(0, hHint - insets.getHeight());
            }
        } else {
            hHint = -1;
            if (wHint >= 0) {
                wHint = Math.max(0, wHint - insets.getWidth());
            }
        }
        int i = 0;
        while (i < figure.getChildren().size()) {
            IFigure child = (IFigure)figure.getChildren().get(i);
            Dimension d = SizeLibrary.getCalculateAndDefaultSize(child, wHint, wHint);
            if (isHorizontal) {
                if (d.width != -1) {
                    width += d.width;
                }
                if (d.height != -1 && height < d.height) {
                    height = d.height;
                }
            } else {
                if (d.height != -1) {
                    height += d.height;
                }
                if (d.width != -1 && width < d.width) {
                    width = d.width;
                }
            }
            ++i;
        }
        if (wHint >= 0 && width > wHint) {
            width = wHint;
        } else if (hHint >= 0 && height > hHint) {
            height = hHint;
        }
        int spacing = ((ToolbarLayout)figure.getLayoutManager()).getSpacing();
        if (isHorizontal) {
            width += Math.max(0, figure.getChildren().size() - 1) * spacing;
        } else {
            height += Math.max(0, figure.getChildren().size() - 1) * spacing;
        }
        Transposer transposer = new Transposer();
        Dimension d2 = transposer.t(new Dimension(width, height)).expand(insets.getWidth(), insets.getHeight()).union(SizeLibrary.getBorderPreferredSize(figure));
        return d2;
    }

    private static Dimension getBorderPreferredSize(IFigure container) {
        if (container.getBorder() == null) {
            return new Dimension();
        }
        return container.getBorder().getPreferredSize(container);
    }
}

