/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amateras.air.mxml.figures;

import net.sf.amateras.air.mxml.figures.ContainerFigure;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.geometry.Insets;

public class ViewStackFigure
extends ContainerFigure {
    private StackLayout layout = new StackLayout();
    private IFigure selectedFigure;

    public ViewStackFigure() {
        this.setLayoutManager((LayoutManager)this.layout);
        this.setBorder((Border)new ViewStackBorder());
    }

    public IFigure getSelectedFigure() {
        return this.selectedFigure;
    }

    public void add(IFigure figure, Object constraint, int index) {
        super.add(figure, constraint, index);
        if (this.selectedFigure == null) {
            this.selectedFigure = figure;
            this.selectedFigure.setVisible(true);
        } else {
            figure.setVisible(false);
        }
    }

    public void remove(IFigure figure) {
        super.remove(figure);
    }

    public void setSelectedIndex(int index) {
        int i = 0;
        while (i < this.getChildren().size()) {
            IFigure child = (IFigure)this.getChildren().get(i);
            if (i == index) {
                this.selectedFigure = child;
                this.selectedFigure.setVisible(true);
            } else {
                child.setVisible(false);
            }
            ++i;
        }
    }

    class ViewStackBorder
    extends LineBorder {
        public ViewStackBorder() {
            super(ColorConstants.lightGray, 1);
        }

        public Insets getInsets(IFigure figure) {
            return new Insets(1, 1, 1, 7);
        }

        public void paint(IFigure figure, Graphics graphics, Insets insets) {
            super.paint(figure, graphics, insets);
            try {
                graphics.setForegroundColor(this.getColor());
                int x = figure.getBounds().x;
                int y = figure.getBounds().y;
                int width = figure.getBounds().width;
                int height = figure.getBounds().height;
                graphics.setLineWidth(1);
                graphics.drawLine(x + width - 3, y, x + width - 3, y + height);
                graphics.drawLine(x + width - 5, y, x + width - 5, y + height);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

