/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amateras.air.mxml.figures;

import java.util.HashMap;
import java.util.Map;
import net.sf.amateras.air.mxml.figures.ContainerFigure;
import net.sf.amateras.air.mxml.figures.TitleLabel;
import net.sf.amateras.air.mxml.models.FlexRectangle;
import org.eclipse.draw2d.BorderLayout;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;

public class AccordionFigure
extends ContainerFigure
implements MouseListener {
    private int selectIndex = -1;
    private IFigure selectedFigure;
    private Map<IFigure, IFigure> childs = new HashMap<IFigure, IFigure>();

    public AccordionFigure() {
        this.setLayoutManager((LayoutManager)new ToolbarLayout());
        this.setOpaque(true);
    }

    public void add(IFigure figure, String text, Object constraint, int index) {
        Figure addFigure = new Figure();
        FlexRectangle rectangle = new FlexRectangle();
        addFigure.setBounds((Rectangle)rectangle);
        addFigure.setLayoutManager((LayoutManager)new BorderLayout());
        Label label = this.getTitleLabel(text);
        addFigure.add((IFigure)label, (Object)BorderLayout.TOP, -1);
        addFigure.add(figure, (Object)BorderLayout.CENTER, -1);
        label.addMouseListener((MouseListener)this);
        this.childs.put(figure, (IFigure)addFigure);
        super.add((IFigure)addFigure, constraint, index);
    }

    public void remove(IFigure figure) {
        IFigure addFigure = this.childs.get(figure);
        super.remove(addFigure);
    }

    private Label getTitleLabel(String text) {
        TitleLabel label = new TitleLabel();
        label.setText(text);
        return label;
    }

    public void add(IFigure figure, Object constraint, int index) {
    }

    public int getDefaultWidth() {
        return 56;
    }

    public int getDefaultHeight() {
        return 22;
    }

    public void setSelectedIndex(int selectIndex) {
        this.selectIndex = selectIndex;
        int i = 0;
        while (i < this.getChildren().size()) {
            IFigure child = (IFigure)this.getChildren().get(i);
            IFigure original = (IFigure)child.getChildren().get(1);
            if (selectIndex == i) {
                original.setPreferredSize(new Dimension(this.getBounds().width, this.getBounds().height));
                this.selectedFigure = original;
                original.setVisible(true);
            } else {
                original.setVisible(false);
            }
            ++i;
        }
    }

    public void setBounds(Rectangle rect) {
        super.setBounds(rect);
        if (this.selectedFigure != null) {
            this.selectedFigure.setPreferredSize(new Dimension(this.getBounds().width, this.getBounds().height));
        }
    }

    public void mouseDoubleClicked(MouseEvent me) {
    }

    public void mousePressed(MouseEvent me) {
        Object ms = me.getSource();
        int i = 0;
        while (i < this.getChildren().size()) {
            Object obj = ((IFigure)this.getChildren().get(i)).getChildren().get(0);
            if (obj == ms) {
                this.setSelectedIndex(i);
                return;
            }
            ++i;
        }
    }

    public void mouseReleased(MouseEvent me) {
    }

    public int getSelectIndex() {
        return this.selectIndex;
    }
}

