/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amateras.air.mxml.editparts.policy;

import net.sf.amateras.air.mxml.editparts.command.AddCommand;
import net.sf.amateras.air.mxml.editparts.command.ChangeConstraintCommand;
import net.sf.amateras.air.mxml.editparts.command.CreateCommand;
import net.sf.amateras.air.mxml.editparts.command.OrphanChildrenCommand;
import net.sf.amateras.air.mxml.models.FlexRectangle;
import net.sf.amateras.air.mxml.models.IComponentModel;
import net.sf.amateras.air.mxml.models.IContainerModel;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.ResizableEditPolicy;
import org.eclipse.gef.editpolicies.XYLayoutEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.GroupRequest;

public class RootEditPolicy
extends XYLayoutEditPolicy {
    protected EditPolicy createChildEditPolicy(EditPart child) {
        return new ResizableEditPolicy(){

            protected void showChangeBoundsFeedback(ChangeBoundsRequest request) {
                IFigure feedback = this.getDragSourceFeedbackFigure();
                PrecisionRectangle rect = new PrecisionRectangle(this.getInitialFeedbackBounds().getCopy());
                this.getHostFigure().translateToAbsolute((Translatable)rect);
                rect.translate(request.getMoveDelta());
                rect.resize(request.getSizeDelta());
                RootEditPolicy.this.snapToGrid((Rectangle)rect);
                feedback.translateToRelative((Translatable)rect);
                feedback.setBounds((Rectangle)rect);
            }
        };
    }

    protected void showSizeOnDropFeedback(CreateRequest request) {
        Point p = new Point(request.getLocation().getCopy());
        IFigure feedback = this.getSizeOnDropFeedback(request);
        feedback.translateToRelative((Translatable)p);
        Dimension size = request.getSize().getCopy();
        feedback.translateToRelative((Translatable)size);
        Rectangle rectangle = new Rectangle(p, size).expand(this.getCreationFeedbackOffset(request));
        this.snapToGrid(rectangle);
        feedback.setBounds(rectangle);
    }

    protected Command createAddCommand(EditPart child, Object constraint) {
        IContainerModel root = (IContainerModel)this.getHost().getModel();
        IComponentModel childModel = (IComponentModel)child.getModel();
        Rectangle rectangle = (Rectangle)constraint;
        this.snapToGrid(rectangle);
        FlexRectangle fr = new FlexRectangle();
        fr.setRectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        return new AddCommand(root, childModel, null, fr);
    }

    protected Command createChangeConstraintCommand(EditPart child, Object constraint) {
        Rectangle rectangle = (Rectangle)constraint;
        this.snapToGrid(rectangle);
        ChangeConstraintCommand command = new ChangeConstraintCommand();
        command.setModel((IComponentModel)child.getModel());
        FlexRectangle fr = new FlexRectangle();
        fr.setRectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        command.setConstraint(fr);
        return command;
    }

    protected Command getCreateCommand(CreateRequest request) {
        Rectangle rectangle = (Rectangle)this.getConstraintFor(request);
        this.snapToGrid(rectangle);
        IContainerModel root = (IContainerModel)this.getHost().getModel();
        FlexRectangle fr = new FlexRectangle();
        fr.setRectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        return new CreateCommand(root, request, fr);
    }

    protected Command getDeleteDependantCommand(Request request) {
        return null;
    }

    protected Command getOrphanChildrenCommand(Request request) {
        GroupRequest gRequest = (GroupRequest)request;
        return new OrphanChildrenCommand(gRequest.getEditParts());
    }

    protected Object translateToModelConstraint(Object figureConstraint) {
        if (figureConstraint instanceof FlexRectangle) {
            FlexRectangle fr = (FlexRectangle)figureConstraint;
            fr.setX(fr.x);
            fr.setY(fr.y);
            fr.setWidth(fr.width);
            fr.setHeight(fr.height);
        }
        return super.translateToModelConstraint(figureConstraint);
    }

    protected void snapToGrid(Rectangle rectangle) {
        rectangle.x = this.roundValue(rectangle.x);
        rectangle.y = this.roundValue(rectangle.y);
        rectangle.width = this.roundValue(rectangle.width);
        rectangle.height = this.roundValue(rectangle.height);
    }

    private int roundValue(int value) {
        int div = value % 10;
        if (div >= 5) {
            return value + (10 - div);
        }
        return value - div;
    }
}

