/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amateras.air.mxml.editparts.policy;

import java.util.List;
import net.sf.amateras.air.mxml.editparts.command.AddCommand;
import net.sf.amateras.air.mxml.editparts.command.ChangeConstraintCommand;
import net.sf.amateras.air.mxml.editparts.command.CreateCommand;
import net.sf.amateras.air.mxml.editparts.command.MoveChildCommand;
import net.sf.amateras.air.mxml.editparts.command.OrphanChildrenCommand;
import net.sf.amateras.air.mxml.models.FlexRectangle;
import net.sf.amateras.air.mxml.models.IComponentModel;
import net.sf.amateras.air.mxml.models.IContainerModel;
import org.eclipse.draw2d.FlowLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.editpolicies.FlowLayoutEditPolicy;
import org.eclipse.gef.editpolicies.ResizableEditPolicy;
import org.eclipse.gef.requests.AlignmentRequest;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.GroupRequest;

public class ResizeableFlowLayoutEditPolicy
extends FlowLayoutEditPolicy {
    public boolean isHorizontal() {
        IFigure figure = ((GraphicalEditPart)this.getHost()).getContentPane();
        LayoutManager layout = figure.getLayoutManager();
        if (layout instanceof FlowLayout) {
            return ((FlowLayout)figure.getLayoutManager()).isHorizontal();
        }
        if (layout instanceof ToolbarLayout) {
            return ((ToolbarLayout)figure.getLayoutManager()).isHorizontal();
        }
        return false;
    }

    protected Command createAddCommand(EditPart child, EditPart after) {
        IContainerModel root = (IContainerModel)this.getHost().getModel();
        IComponentModel childModel = (IComponentModel)child.getModel();
        IComponentModel afterModel = after == null ? null : (IComponentModel)after.getModel();
        return new AddCommand(root, childModel, afterModel, childModel.getConstraint());
    }

    protected Command createMoveChildCommand(EditPart child, EditPart after) {
        return new MoveChildCommand(this.getHost(), child, after);
    }

    protected Command getCreateCommand(CreateRequest request) {
        IContainerModel root = (IContainerModel)this.getHost().getModel();
        return new CreateCommand(root, request, null);
    }

    protected Command getOrphanChildrenCommand(Request request) {
        GroupRequest gRequest = (GroupRequest)request;
        return new OrphanChildrenCommand(gRequest.getEditParts());
    }

    protected EditPolicy createChildEditPolicy(EditPart child) {
        return new ResizableEditPolicy();
    }

    public Command getCommand(Request request) {
        if ("resize children".equals(request.getType())) {
            return this.getResizeChildrenCommand((ChangeBoundsRequest)request);
        }
        if ("align children".equals(request.getType())) {
            return this.getAlignChildrenCommand((AlignmentRequest)request);
        }
        return super.getCommand(request);
    }

    protected Command getAlignChildrenCommand(AlignmentRequest request) {
        return this.getResizeChildrenCommand((ChangeBoundsRequest)request);
    }

    protected Object getConstraintFor(ChangeBoundsRequest request, GraphicalEditPart child) {
        PrecisionRectangle rect = new PrecisionRectangle(child.getFigure().getBounds());
        child.getFigure().translateToAbsolute((Translatable)rect);
        rect = request.getTransformedRectangle((Rectangle)rect);
        child.getFigure().translateToRelative((Translatable)rect);
        rect.translate(this.getLayoutOrigin().getNegated());
        return this.getConstraintFor((Rectangle)rect);
    }

    public Object getConstraintFor(Rectangle r) {
        return new Rectangle(r);
    }

    protected Point getLayoutOrigin() {
        return this.getLayoutContainer().getClientArea().getLocation();
    }

    protected Command getResizeChildrenCommand(ChangeBoundsRequest request) {
        CompoundCommand resize = new CompoundCommand();
        List children = request.getEditParts();
        int i = 0;
        while (i < children.size()) {
            GraphicalEditPart child = (GraphicalEditPart)children.get(i);
            Command c = this.createChangeConstraintCommand(request, (EditPart)child, this.translateToModelConstraint(this.getConstraintFor(request, child)));
            resize.add(c);
            ++i;
        }
        return resize.unwrap();
    }

    protected Object translateToModelConstraint(Object figureConstraint) {
        return figureConstraint;
    }

    protected Command createChangeConstraintCommand(ChangeBoundsRequest request, EditPart child, Object constraint) {
        return this.createChangeConstraintCommand(child, constraint);
    }

    protected Command createChangeConstraintCommand(EditPart child, Object constraint) {
        Rectangle rectangle = (Rectangle)constraint;
        this.snapToGrid(rectangle);
        ChangeConstraintCommand command = new ChangeConstraintCommand();
        command.setModel((IComponentModel)child.getModel());
        FlexRectangle fr = new FlexRectangle();
        fr.setWidth(rectangle.width);
        fr.setHeight(rectangle.height);
        command.setConstraint(fr);
        return command;
    }

    private void snapToGrid(Rectangle rectangle) {
        rectangle.x = this.roundValue(rectangle.x);
        rectangle.y = this.roundValue(rectangle.y);
        rectangle.width = this.roundValue(rectangle.width);
        rectangle.height = this.roundValue(rectangle.height);
    }

    private int roundValue(int value) {
        int div = value % 10;
        if (div >= 5) {
            return value + (10 - div);
        }
        return value - div;
    }
}

