/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amateras.air.mxml.editparts.command;

import net.sf.amateras.air.mxml.models.AbstractComponentModel;
import net.sf.amateras.air.mxml.models.IComponentModel;
import net.sf.amateras.air.mxml.models.IContainerModel;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;

public class MoveChildCommand
extends Command {
    protected IComponentModel model;
    protected IContainerModel root;
    protected IContainerModel oldRoot;
    protected EditPart after;
    protected int beforeIndex = -1;
    protected int addIndex = -1;

    public MoveChildCommand(EditPart host, EditPart child, EditPart after) {
        this.root = (IContainerModel)host.getModel();
        this.model = (IComponentModel)child.getModel();
        this.beforeIndex = this.root.getChildIndex(this.model);
        this.after = after;
        if (after != null) {
            this.oldRoot = ((AbstractComponentModel)after.getModel()).getRoot();
            AbstractComponentModel afterModel = (AbstractComponentModel)after.getModel();
            if (this.oldRoot != null) {
                this.addIndex = this.oldRoot.getChildIndex(afterModel);
            }
        }
    }

    public void execute() {
        if (this.oldRoot != null) {
            this.oldRoot.removeChild(this.model);
            if (this.addIndex >= 0) {
                this.root.addChild(this.addIndex, this.model);
            } else {
                this.root.addChild(this.model);
            }
        }
    }

    public void undo() {
        this.root.removeChild(this.model);
        if (this.oldRoot != null) {
            this.oldRoot.addChild(this.beforeIndex, this.model);
        }
    }

    public boolean canExecute() {
        if (this.root == null) {
            return false;
        }
        return this.root.canChildComponent(this.model);
    }
}

