/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amateras.air.mxml.editparts.command;

import net.sf.amateras.air.mxml.models.FlexRectangle;
import net.sf.amateras.air.mxml.models.IComponentModel;
import net.sf.amateras.air.mxml.models.IContainerModel;
import net.sf.amateras.air.mxml.models.IInstallDefault;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.CreateRequest;

public class CreateCommand
extends Command {
    private IContainerModel root;
    private CreateRequest request;
    private FlexRectangle constraint;
    private IComponentModel model;

    public CreateCommand(IContainerModel root, CreateRequest request, FlexRectangle constraint) {
        this.root = root;
        this.request = request;
        this.constraint = constraint;
        this.model = (IComponentModel)request.getNewObject();
    }

    public CreateCommand(IContainerModel root, IComponentModel createModel, FlexRectangle constraint) {
        this.root = root;
        this.constraint = constraint;
        this.model = createModel;
    }

    public void execute() {
        if (this.constraint == null) {
            this.constraint = new FlexRectangle();
            int width = 0;
            int height = 0;
            if (this.request != null && this.request.getSize() != null) {
                width = this.request.getSize().width;
                height = this.request.getSize().height;
                if (width < 100) {
                    width = 100;
                }
                if (height < 10) {
                    height = 10;
                }
            }
            this.constraint.setHeight(height);
            this.constraint.setWidth(width);
        }
        this.model.setConstraint(this.constraint);
        if (this.model instanceof IInstallDefault) {
            ((IInstallDefault)((Object)this.model)).installDefault();
        }
        this.root.addChild(this.model);
    }

    public void undo() {
        this.root.removeChild(this.model);
    }

    public boolean canExecute() {
        if (this.root == null) {
            return false;
        }
        return this.root.canChildComponent(this.model);
    }
}

