/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amateras.air.mxml.editparts;

import java.util.List;
import net.sf.amateras.air.mxml.editparts.AbstractComponentEditPart;
import net.sf.amateras.air.mxml.editparts.policy.ResizeableFlowLayoutEditPolicy;
import net.sf.amateras.air.mxml.figures.BoxFigure;
import net.sf.amateras.air.mxml.models.BoxModel;
import net.sf.amateras.air.mxml.models.IContainerModel;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.gef.EditPolicy;
import org.eclipse.swt.graphics.RGB;

public class BoxEditPart
extends AbstractComponentEditPart {
    protected IFigure createFigure() {
        BoxFigure figure = new BoxFigure();
        this.updateFigure((BoxModel)this.getModel(), figure);
        return figure;
    }

    protected List getModelChildren() {
        return ((IContainerModel)this.getModel()).getChildren();
    }

    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new ResizeableFlowLayoutEditPolicy());
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        BoxModel model = (BoxModel)this.getModel();
        BoxFigure figure = (BoxFigure)this.getFigure();
        this.updateFigure(model, figure);
    }

    protected void updateFigure(BoxModel model, BoxFigure figure) {
        figure.setToolTip((IFigure)new Label(model.toString()));
        String direction = (String)model.getAttribute("direction");
        if (direction.equalsIgnoreCase("vertical")) {
            figure.setVertical(true);
            try {
                figure.setSpacing(model.getAttributeToNumber("verticalGap"));
            }
            catch (NumberFormatException numberFormatException) {}
        } else {
            figure.setVertical(false);
            try {
                figure.setSpacing(model.getAttributeToNumber("horizontalGap"));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        try {
            int top = model.getAttributeToNumber("paddingTop");
            int left = model.getAttributeToNumber("paddingLeft");
            int right = model.getAttributeToNumber("paddingRight");
            int bottom = model.getAttributeToNumber("paddingBottom");
            figure.setPadding(new Insets(top, left, bottom, right));
        }
        catch (NumberFormatException numberFormatException) {}
        figure.setBackgroundColor(this.getColor((RGB)model.getAttribute("backgroundColor")));
        figure.revalidate();
    }
}

