/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amateras.air.mxml.descriptor;

import net.sf.amateras.air.mxml.descriptor.IEditorValueDescriptor;
import net.sf.amateras.air.mxml.descriptor.PropertyLabelDecoratorUtil;
import net.sf.amateras.air.mxml.models.AbstractModel;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DoublePropertyDescriptor
extends TextPropertyDescriptor
implements IEditorValueDescriptor<Double> {
    private Double defaultValue;

    public DoublePropertyDescriptor(Object id, String displayName, Double defaultValue) {
        super(id, displayName);
        this.setValidator(new DoubleValidator());
        this.defaultValue = defaultValue;
        this.setLabelProvider((ILabelProvider)new MyLabelDecorator());
    }

    public CellEditor createPropertyEditor(Composite parent) {
        DoubleCellEditor editor = new DoubleCellEditor(parent);
        if (this.getValidator() != null) {
            editor.setValidator(this.getValidator());
        }
        return editor;
    }

    @Override
    public Double getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public Double getEditorValue(Double value) {
        if (value != null) {
            return value;
        }
        return this.defaultValue;
    }

    class DoubleCellEditor
    extends TextCellEditor {
        DoubleCellEditor(Composite parent) {
            super(parent);
        }

        protected void doSetValue(Object value) {
            if (value == null || value == AbstractModel.NULL_PROPERTY) {
                this.text.setText(AbstractModel.NULL_PROPERTY);
            } else {
                Assert.isTrue((this.text != null && value instanceof Double ? 1 : 0) != 0);
                this.text.setText(String.valueOf(value));
            }
        }

        protected Object doGetValue() {
            String value = this.text.getText();
            if (value == null || value.length() == 0) {
                return AbstractModel.NULL_PROPERTY;
            }
            return Double.valueOf(value);
        }
    }

    class DoubleValidator
    implements ICellEditorValidator {
        DoubleValidator() {
        }

        public String isValid(Object value) {
            if (value != null && value.toString().length() > 0) {
                char[] charArray = value.toString().toCharArray();
                int i = 0;
                while (i < charArray.length) {
                    if (!(Character.isDigit(charArray[i]) || i == 0 && charArray[i] == '-' || charArray[i] == '.')) {
                        return "The input value is not a numerical value. ";
                    }
                    ++i;
                }
                return null;
            }
            return null;
        }
    }

    class MyLabelDecorator
    extends PropertyLabelDecoratorUtil {
        MyLabelDecorator() {
        }

        protected String getDefaultValue() {
            if (DoublePropertyDescriptor.this.defaultValue == null) {
                return AbstractModel.NULL_PROPERTY;
            }
            return DoublePropertyDescriptor.this.defaultValue.toString();
        }
    }
}

