/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amateras.air.launch;

import net.sf.amateras.air.AIRPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class LaunchAIRShortcut
implements ILaunchShortcut {
    public void launch(ISelection selection, String mode) {
        if (selection != null && selection instanceof IStructuredSelection && !selection.isEmpty()) {
            IProject targetProject = null;
            Object obj = ((IStructuredSelection)selection).getFirstElement();
            if (obj instanceof IProject) {
                targetProject = (IProject)obj;
            } else if (obj instanceof IResource) {
                targetProject = ((IResource)obj).getProject();
            } else if (obj instanceof IAdaptable) {
                targetProject = (IProject)((IAdaptable)obj).getAdapter(IProject.class);
            }
            if (targetProject != null) {
                this.launch(targetProject);
            }
        }
    }

    public void launch(IEditorPart editor, String mode) {
        IEditorInput input = editor.getEditorInput();
        if (input instanceof IFileEditorInput) {
            IProject targetProject = ((IFileEditorInput)input).getFile().getProject();
            this.launch(targetProject);
        }
    }

    private void launch(IProject targetProject) {
        try {
            ILaunchConfiguration config = this.getLaunchConfiguration(targetProject);
            DebugUITools.launch((ILaunchConfiguration)config, (String)"run");
        }
        catch (Exception ex) {
            AIRPlugin.logException(ex);
        }
    }

    private ILaunchConfiguration getLaunchConfiguration(IProject project) throws CoreException {
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfiguration[] configs = manager.getLaunchConfigurations();
        int i = 0;
        while (i < configs.length) {
            String value = configs[i].getAttribute("air.project", "");
            if (value.equals(project.getName())) {
                return configs[i];
            }
            ++i;
        }
        ILaunchConfigurationType type = manager.getLaunchConfigurationType("net.sf.amateras.air.launchAIRConfigurationType");
        ILaunchConfigurationWorkingCopy wc = type.newInstance(null, manager.generateUniqueLaunchConfigurationNameFrom(project.getName()));
        ScopedPreferenceStore projectStore = new ScopedPreferenceStore((IScopeContext)new ProjectScope(project), "net.sf.amateras.air");
        String descriptor = projectStore.getString("decriptor");
        wc.setAttribute("air.project", project.getName());
        wc.setAttribute("air.target", descriptor);
        wc.setAttribute("org.eclipse.debug.ui.ATTR_LAUNCH_IN_BACKGROUND", false);
        return wc.doSave();
    }
}

