/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amateras.air.launch;

import net.sf.amateras.air.AIRPlugin;
import net.sf.amateras.air.util.UIUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class LaunchAIRMainTab
extends AbstractLaunchConfigurationTab {
    public static final String ATTR_PROJECT = "air.project";
    public static final String ATTR_TARGET = "air.target";
    public static final String ATTR_TARGET_ENABLE_LAUNCH = "air.target.enable.lanch";
    private Text textProject;
    private Text textDescriptor;
    private Button chkEnableLancherSetting;
    private boolean isValid = true;

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        composite.setLayoutData((Object)new GridData(1808));
        this.createFileGroup(composite);
        this.setControl((Control)composite);
    }

    private void createFileGroup(Composite composite) {
        Group projectGroup = new Group(composite, 0);
        projectGroup.setText("Project");
        projectGroup.setLayout((Layout)new GridLayout(2, false));
        projectGroup.setLayoutData((Object)new GridData(768));
        this.textProject = new Text((Composite)projectGroup, 2048);
        this.textProject.setLayoutData((Object)new GridData(768));
        this.textProject.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LaunchAIRMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        Button browseFile = new Button((Composite)projectGroup, 8);
        browseFile.setText("Browse...");
        browseFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                IProject project = UIUtil.browseProject();
                if (project != null) {
                    LaunchAIRMainTab.this.textProject.setText(project.getName());
                    ScopedPreferenceStore projectStore = new ScopedPreferenceStore((IScopeContext)new ProjectScope(project), "net.sf.amateras.air");
                    LaunchAIRMainTab.this.textDescriptor.setText(projectStore.getString("decriptor"));
                    LaunchAIRMainTab.this.updateLaunchConfigurationDialog();
                }
            }
        });
        Group descriptorGroup = new Group(composite, 0);
        descriptorGroup.setText("Application Descriptor");
        descriptorGroup.setLayout((Layout)new GridLayout(1, false));
        descriptorGroup.setLayoutData((Object)new GridData(768));
        this.textDescriptor = new Text((Composite)descriptorGroup, 2048);
        this.textDescriptor.setLayoutData((Object)new GridData(768));
        this.textDescriptor.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LaunchAIRMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.chkEnableLancherSetting = this.createCheckButton((Composite)descriptorGroup, "Enable Lancher setting");
        this.chkEnableLancherSetting.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (LaunchAIRMainTab.this.chkEnableLancherSetting.getSelection()) {
                    LaunchAIRMainTab.this.textDescriptor.setEnabled(true);
                } else {
                    LaunchAIRMainTab.this.textDescriptor.setEnabled(false);
                }
                LaunchAIRMainTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            String project = configuration.getAttribute(ATTR_PROJECT, "");
            this.textProject.setText(project);
            if (LaunchAIRMainTab.isEnableDescriptorEx(configuration)) {
                this.chkEnableLancherSetting.setSelection(true);
                this.textDescriptor.setEnabled(true);
                this.textDescriptor.setText(configuration.getAttribute(ATTR_TARGET, ""));
            } else {
                this.chkEnableLancherSetting.setSelection(false);
                this.textDescriptor.setEnabled(false);
                IProject prj = ResourcesPlugin.getWorkspace().getRoot().getProject(project);
                this.textDescriptor.setText(LaunchAIRMainTab.getProjectDescriptor(prj));
            }
        }
        catch (Exception ex) {
            AIRPlugin.logException(ex);
        }
    }

    public static boolean isEnableDescriptorEx(ILaunchConfiguration configration) throws CoreException {
        String enable = configration.getAttribute(ATTR_TARGET_ENABLE_LAUNCH, "false");
        return enable.equals("true");
    }

    public static String getProjectDescriptor(IProject project) {
        ScopedPreferenceStore projectStore = new ScopedPreferenceStore((IScopeContext)new ProjectScope(project), "net.sf.amateras.air");
        return projectStore.getString("decriptor");
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        String projectName = this.textProject.getText();
        if (projectName.length() == 0) {
            this.setErrorMessage("Project not found.");
            this.isValid = false;
            return;
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (project == null || !project.exists()) {
            this.setErrorMessage("Project not found.");
            this.isValid = false;
            return;
        }
        String descriptor = null;
        descriptor = this.chkEnableLancherSetting.getSelection() ? this.textDescriptor.getText() : LaunchAIRMainTab.getProjectDescriptor(project);
        if (descriptor == null || descriptor.length() == 0 || !project.getFile((IPath)new Path(descriptor)).exists()) {
            this.setErrorMessage("Application Descriptor not found.");
            this.isValid = false;
        }
        configuration.setAttribute(ATTR_TARGET_ENABLE_LAUNCH, this.chkEnableLancherSetting.getSelection() ? "true" : "false");
        configuration.setAttribute(ATTR_TARGET, descriptor);
        configuration.setAttribute(ATTR_PROJECT, projectName);
        this.setErrorMessage(null);
        this.isValid = true;
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        return this.isValid;
    }

    public String getName() {
        return "Main";
    }
}

