/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amateras.air.launch;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.sf.amateras.air.AIRPlugin;
import net.sf.amateras.air.util.ProcessUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.externaltools.internal.model.BuilderUtils;

public class LaunchADTConfiguration
extends LaunchConfigurationDelegate
implements IDebugEventSetListener {
    public static final String ID = "net.sf.amateras.air.launchADTConfigurationType";
    public static final String KEY_PROJECT = "air.PROJECT";
    public static final String KEY_OPTIONS = "air.OPTIONS";

    public void handleDebugEvents(DebugEvent[] events) {
    }

    protected IProject[] getBuildOrder(ILaunchConfiguration configuration, String mode) throws CoreException {
        String projectName = configuration.getAttribute(KEY_PROJECT, "");
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (project == null) {
            return null;
        }
        return new IProject[]{project};
    }

    public String getAdtPath() {
        IPreferenceStore store = AIRPlugin.getDefault().getPreferenceStore();
        String adtPath = store.getString("adtCommand");
        return adtPath;
    }

    public void launch(ILaunchConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        this.launch(configuration, "run", null, monitor);
    }

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        String projectName = configuration.getAttribute(KEY_PROJECT, "");
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        IPreferenceStore store = AIRPlugin.getDefault().getPreferenceStore();
        if (project == null || !ProcessUtil.checkAirGearProject(project)) {
            return;
        }
        String adtPath = store.getString("adtCommand");
        String sdkPath = ProcessUtil.getAirSdkPath(adtPath);
        if (sdkPath == null) {
            return;
        }
        File adt = new File(sdkPath, adtPath);
        File currentDir = new File(project.getLocation().toString());
        try {
            List options = configuration.getAttribute(KEY_OPTIONS, new ArrayList());
            String[] args = options.toArray(new String[options.size()]);
            StringBuilder sb = new StringBuilder();
            sb.append("adt");
            String[] stringArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                String arg = stringArray[n2];
                sb.append(" " + arg);
                ++n2;
            }
            Process process = ProcessUtil.createProcess(adt, args, currentDir);
            MyLaunch myLaunch = new MyLaunch(configuration, "run", null);
            IProcess proc = DebugPlugin.newProcess((ILaunch)myLaunch, (Process)process, (String)sb.toString());
            myLaunch.setProcess(proc);
            DebugPlugin.getDefault().getLaunchManager().addLaunch((ILaunch)myLaunch);
            DebugUIPlugin.getDefault().getProcessConsoleManager().launchAdded(launch);
            process.waitFor();
            project.refreshLocal(2, null);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static ILaunchConfigurationWorkingCopy getADTConfiguration(IProject project, String name) {
        try {
            ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
            ILaunchConfigurationType type = manager.getLaunchConfigurationType(ID);
            ILaunchConfigurationWorkingCopy workingCopy = null;
            workingCopy = type.newInstance((IContainer)BuilderUtils.getBuilderFolder((IProject)project, (boolean)true), name);
            workingCopy.doSave();
            return workingCopy;
        }
        catch (CoreException e) {
            e.printStackTrace();
            return null;
        }
    }

    class MyLaunch
    extends Launch {
        private IProcess process;

        public MyLaunch(ILaunchConfiguration launchConfiguration, String mode, ISourceLocator locator) {
            super(launchConfiguration, mode, locator);
        }

        public void setProcess(IProcess process) {
            this.process = process;
        }

        public IProcess[] getProcesses() {
            if (this.process == null) {
                return null;
            }
            return new IProcess[]{this.process};
        }
    }
}

