/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amateras.air.builder;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.amateras.air.AIRPlugin;
import net.sf.amateras.air.builder.FcshShell;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class MXMLCompiler {
    private IProject project;
    private Map<String, String> idMap = Collections.synchronizedMap(new HashMap());
    private Pattern pattern;

    public MXMLCompiler(IProject project, Pattern pattern) {
        this.project = project;
        this.pattern = pattern;
    }

    public void setMessagePattern(Pattern pattern) {
        this.pattern = pattern;
    }

    public void dispose() {
        this.project = null;
        this.pattern = null;
        this.idMap.clear();
    }

    public String requestCompileMXML(String name, FcshShell fcsh, IProgressMonitor monitor) throws IOException, CoreException {
        String command = null;
        if (this.idMap.containsKey(name)) {
            String id = this.idMap.get(name);
            command = "compile " + id + "\n";
        } else {
            IPreferenceStore preferenceStore = AIRPlugin.getDefault().getPreferenceStore();
            String preCommand = preferenceStore.getString("flexCompileCommand");
            command = preCommand + " " + name;
            ScopedPreferenceStore store = new ScopedPreferenceStore((IScopeContext)new ProjectScope(this.project), "net.sf.amateras.air");
            String libraries = store.getString("flexLibraries");
            if (libraries.length() > 0) {
                command = String.valueOf(command) + " -library-path+=" + libraries;
            }
            command = String.valueOf(command) + "\n";
        }
        monitor.setTaskName(String.format(AIRPlugin.getResourceString("COMPILE_START_COMPILE"), command));
        String result = fcsh.startCommand(command, monitor);
        Matcher matcher = this.pattern.matcher(result);
        if (matcher.find()) {
            String id = matcher.group(1);
            this.idMap.put(name, id);
        }
        this.project.refreshLocal(2, null);
        return result;
    }

    public String requestCompile(String compileCommand, FcshShell fcsh, IProgressMonitor monitor) throws IOException, CoreException {
        String command = null;
        if (this.idMap.containsKey(compileCommand)) {
            String id = this.idMap.get(compileCommand);
            command = "compile " + id + "\n";
        } else {
            command = compileCommand + "\n";
        }
        monitor.setTaskName(String.format(AIRPlugin.getResourceString("COMPILE_START_COMPILE"), command));
        String result = fcsh.startCommand(command, monitor);
        Matcher matcher = this.pattern.matcher(result);
        if (matcher.find()) {
            String id = matcher.group(1);
            this.idMap.put(compileCommand, id);
        }
        this.project.refreshLocal(2, null);
        return result;
    }
}

