/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amateras.air.builder;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.amateras.air.AIRPlugin;
import net.sf.amateras.air.builder.FcshShell;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class CompcCompiler {
    private IProject project;
    private Map<String, String> idMap = Collections.synchronizedMap(new HashMap());
    private Pattern pattern;

    public CompcCompiler(IProject project, Pattern pattern) {
        this.project = project;
        this.pattern = pattern;
    }

    public void setMessagePattern(Pattern pattern) {
        this.pattern = pattern;
    }

    public void dispose() {
        this.project = null;
        this.pattern = null;
        this.idMap.clear();
    }

    public String requestCompile(String compileCommand, FcshShell fcsh, IProgressMonitor monitor) throws IOException, CoreException {
        String command = null;
        StringBuilder sb = new StringBuilder();
        sb.append(compileCommand);
        sb.append("\n");
        command = sb.toString();
        if (this.idMap.containsKey(command)) {
            String id = this.idMap.get(command);
            command = "compile " + id + "\n";
        }
        monitor.setTaskName(String.format(AIRPlugin.getResourceString("COMPILE_START_COMPILE"), command));
        String result = fcsh.startCommand(command, monitor);
        Matcher matcher = this.pattern.matcher(result);
        if (matcher.find()) {
            String id = matcher.group(1);
            this.idMap.put(command, id);
        }
        this.project.refreshLocal(2, null);
        sb.append(result);
        return sb.toString();
    }
}

