/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amateras.air.builder;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.amateras.air.AIRPlugin;
import net.sf.amateras.air.builder.AbstractAIRBuilder;
import net.sf.amateras.air.builder.CompcCompiler;
import net.sf.amateras.air.builder.CompileProperty;
import net.sf.amateras.air.builder.FcshShell;
import net.sf.amateras.air.builder.MXMLCompiler;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AirBuilderManager
extends AbstractAIRBuilder {
    public static final String BUILDER_ID = "net.sf.amateras.air.MXMLBuilder";
    public static final String MARKER_ID = "net.sf.amateras.air.MXMLProblemMarker";
    public static final String MARKER_ID_AS3 = "net.sf.amateras.air.AS3ProblemMarker";
    public static Map<IProject, MXMLCompiler> mxmlCompilers = new HashMap<IProject, MXMLCompiler>();
    public static Map<IProject, CompcCompiler> compcCompilers = new HashMap<IProject, CompcCompiler>();

    @Override
    public void fullBuild(IProgressMonitor monitor) throws CoreException {
        ScopedPreferenceStore store = new ScopedPreferenceStore((IScopeContext)new ProjectScope(this.getProject()), "net.sf.amateras.air");
        List<CompileProperty> compiles = CompileProperty.load((IPreferenceStore)store);
        this.compile(compiles, monitor);
    }

    @Override
    public void incrementalBuild(IResourceDelta delta, IProgressMonitor monitor) throws CoreException {
        List<CompileProperty> compiles = this.parseDelta(delta, this.getProject());
        this.compile(compiles, monitor);
    }

    private void compile(List<CompileProperty> compiles, IProgressMonitor monitor) throws CoreException {
        boolean isMxmlBuild = false;
        boolean isAs3Build = false;
        for (CompileProperty prop : compiles) {
            StringBuilder sb = new StringBuilder();
            if (prop.getCommandType() == 2) {
                Object folder = null;
                folder = prop.getDirectory().length() == 0 ? this.getProject() : this.getProject().getFolder(prop.getDirectory());
                ArrayList<String> allASList = new ArrayList<String>();
                this.getAllActionScriptFile(allASList, (IResource)folder);
                for (String fileName : allASList) {
                    fileName = fileName.substring(0, fileName.length() - 3);
                    fileName = fileName.replaceFirst(String.valueOf(prop.getDirectory()) + "/", "");
                    sb.append(" ").append(fileName);
                }
            }
            ScopedPreferenceStore store = new ScopedPreferenceStore((IScopeContext)new ProjectScope(this.getProject()), "net.sf.amateras.air");
            String libraries = store.getString("flexLibraries");
            String command = prop.getCommand();
            command = String.valueOf(command) + " " + this.getReplace(prop.getOption(), sb.toString(), libraries, prop.getDirectory());
            if (prop.getCommandType() == 1) {
                try {
                    if (!isMxmlBuild) {
                        this.getProject().deleteMarkers(MARKER_ID, true, 2);
                        isMxmlBuild = true;
                    }
                    this.compileMXML(command, this.getProject(), monitor);
                    continue;
                }
                catch (IOException ex) {
                    AIRPlugin.logException(ex);
                    throw new CoreException((IStatus)new Status(4, AIRPlugin.getDefault().getBundle().getSymbolicName(), 0, ex.getMessage(), (Throwable)ex));
                }
            }
            if (prop.getCommandType() != 2) continue;
            try {
                if (!isAs3Build) {
                    this.getProject().deleteMarkers(MARKER_ID_AS3, true, 2);
                }
                this.compileAS3(command, this.getProject(), monitor);
            }
            catch (IOException ex) {
                AIRPlugin.logException(ex);
                throw new CoreException((IStatus)new Status(4, AIRPlugin.getDefault().getBundle().getSymbolicName(), 0, ex.getMessage(), (Throwable)ex));
            }
        }
    }

    private void getAllActionScriptFile(final List<String> fileList, IResource folder) throws CoreException {
        folder.accept(new IResourceVisitor(){

            public boolean visit(IResource resource) throws CoreException {
                if (resource instanceof IFile && resource.getName().endsWith(".as")) {
                    String path = resource.getProjectRelativePath().toString();
                    fileList.add(path);
                }
                return true;
            }
        });
    }

    private List<CompileProperty> parseDelta(IResourceDelta delta, IProject project) throws CoreException {
        ScopedPreferenceStore store = new ScopedPreferenceStore((IScopeContext)new ProjectScope(project), "net.sf.amateras.air");
        final List<CompileProperty> compiles = CompileProperty.load((IPreferenceStore)store);
        final ArrayList<CompileProperty> targetCompiles = new ArrayList<CompileProperty>();
        delta.accept(new IResourceDeltaVisitor(){

            public boolean visit(IResourceDelta delta) throws CoreException {
                String path;
                IResource resource = delta.getResource();
                if (resource != null && resource instanceof IFile && (delta.getKind() == 1 || delta.getKind() == 4 || delta.getKind() == 2048) && ((path = resource.getProjectRelativePath().toString()).endsWith(".as") || path.endsWith(".mxml") || path.endsWith(".swc"))) {
                    Object myProp = null;
                    CompileProperty rootProp = null;
                    for (CompileProperty prop : compiles) {
                        String dir = prop.getDirectory().trim();
                        if (dir.length() == 0) {
                            rootProp = prop;
                            continue;
                        }
                        if (!path.startsWith(prop.getDirectory().trim())) continue;
                        targetCompiles.add(prop);
                        System.out.println("add build to:" + prop.getDirectory());
                        compiles.remove(myProp);
                        rootProp = null;
                        break;
                    }
                    if (rootProp != null) {
                        targetCompiles.add(rootProp);
                        compiles.remove(rootProp);
                    }
                }
                return true;
            }
        });
        return targetCompiles;
    }

    public void compileAS3(String command, IProject project, IProgressMonitor monitor) throws CoreException, IOException {
        int workd = 2;
        monitor.worked(workd++);
        FcshShell fcsh = this.createFcshShell(project, monitor);
        CompcCompiler compiler = compcCompilers.get(project);
        if (compiler == null) {
            compiler = new CompcCompiler(project, this.getMessagePattern());
            compcCompilers.put(project, compiler);
        } else {
            compiler.setMessagePattern(this.getMessagePattern());
        }
        monitor.worked(workd++);
        String result = compiler.requestCompile(command, fcsh, monitor);
        monitor.worked(workd++);
        this.addMarker(result, project, MARKER_ID_AS3);
    }

    public void compileMXML(String command, IProject project, IProgressMonitor monitor) throws CoreException, IOException {
        int workd = 2;
        monitor.worked(workd++);
        FcshShell fcsh = this.createFcshShell(project, monitor);
        MXMLCompiler compiler = mxmlCompilers.get(project);
        if (compiler == null) {
            compiler = new MXMLCompiler(project, this.getMessagePattern());
            mxmlCompilers.put(project, compiler);
        } else {
            compiler.setMessagePattern(this.getMessagePattern());
        }
        monitor.worked(workd++);
        String result = compiler.requestCompile(command, fcsh, monitor);
        monitor.worked(workd++);
        this.addMarker(result, project, MARKER_ID);
    }

    @Override
    protected void clearCompiler(IProject project) {
        CompcCompiler comp2;
        MXMLCompiler compiler = mxmlCompilers.remove(project);
        if (compiler != null) {
            compiler.dispose();
        }
        if ((comp2 = compcCompilers.remove(project)) != null) {
            comp2.dispose();
        }
    }

    public static void shutdownCompiler(IProject project) {
        mxmlCompilers.remove(project);
        compcCompilers.remove(project);
        FcshShell fcsh = (FcshShell)fcshShells.get(project);
        if (fcsh != null) {
            fcsh.stopShell();
            fcshShells.remove(project);
        }
    }

    public static void doClean(final IProject project) {
        WorkspaceJob cleanJob = new WorkspaceJob(IDEWorkbenchMessages.CleanDialog_taskName){

            public boolean belongsTo(Object family) {
                return ResourcesPlugin.FAMILY_MANUAL_BUILD.equals(family);
            }

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                project.build(15, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                return Status.OK_STATUS;
            }
        };
        cleanJob.setRule(ResourcesPlugin.getWorkspace().getRuleFactory().buildRule());
        cleanJob.setUser(true);
        cleanJob.schedule();
    }

    public static void shutdownCompilers() {
        mxmlCompilers.clear();
        compcCompilers.clear();
        Object[] fcshs = fcshShells.values().toArray();
        int i = 0;
        while (i < fcshs.length) {
            ((FcshShell)fcshs[i]).stopShell();
            ++i;
        }
        fcshShells.clear();
    }

    private String getReplace(String value, String asFiles, String libraryPath, String directory) {
        try {
            value = value.replaceAll("\\$\\{PROJECT_NAME\\}", this.getProject().getName());
            if (libraryPath.length() > 0) {
                libraryPath = libraryPath.replaceAll("\t", ",");
                value = value.replaceAll("\\$\\{LIBRARY_PATH\\}", libraryPath);
            } else {
                if ((value = value.replaceAll("\\$\\{LIBRARY_PATH\\}", "")).indexOf("-library-path+= ") >= 0) {
                    value = value.replaceAll("-library-path\\+\\= ", "");
                }
                if (value.endsWith("-library-path+=")) {
                    value = value.replaceAll("-library-path\\+\\=", "");
                }
            }
            if (directory.length() == 0) {
                directory = "./";
            }
            value = value.replaceAll("\\$\\{AS_FILES\\}", asFiles);
            value = value.replaceAll("\\$\\{DIRECTORY\\}", directory);
            return value;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return value;
        }
    }
}

