/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amateras.air.builder;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.amateras.air.AIRPlugin;
import net.sf.amateras.air.builder.AirBuilderManager;
import net.sf.amateras.air.builder.FcshShell;
import org.eclipse.core.internal.events.ILifecycleListener;
import org.eclipse.core.internal.events.LifecycleEvent;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.texteditor.MarkerUtilities;

public abstract class AbstractAIRBuilder
extends IncrementalProjectBuilder {
    public static Map<IProject, FcshShell> fcshShells = new HashMap<IProject, FcshShell>();
    private Pattern messagePattern;
    private Pattern errorPattern;
    private Pattern warnPattern;
    private Pattern failPattern;
    private Pattern errorPattern2;
    private Pattern warnPattern2;
    private Pattern failPattern2;
    private boolean isAddInfoMarker;
    private ILifecycleListener lifecycleListener;
    private int workd;

    public AbstractAIRBuilder() {
        IPreferenceStore store = AIRPlugin.getDefault().getPreferenceStore();
        this.getCompileErrorPattern();
        store.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                AbstractAIRBuilder.this.getCompileErrorPattern();
            }
        });
    }

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        this.workd = 0;
        monitor.beginTask("compile", 3);
        if (this.lifecycleListener == null) {
            this.addLifecycleListener();
        }
        if (kind == 6) {
            this.fullBuild(monitor);
        } else {
            IResourceDelta delta = this.getDelta(this.getProject());
            if (delta == null) {
                this.fullBuild(monitor);
            } else {
                this.incrementalBuild(delta, monitor);
            }
        }
        return null;
    }

    public abstract void fullBuild(IProgressMonitor var1) throws CoreException;

    public abstract void incrementalBuild(IResourceDelta var1, IProgressMonitor var2) throws CoreException;

    private void getCompileErrorPattern() {
        IPreferenceStore store = AIRPlugin.getDefault().getPreferenceStore();
        this.messagePattern = this.getPattern(store.getString("compileMessagePattern"));
        this.failPattern = this.getPattern(store.getString("compileFailPattern"));
        this.errorPattern = this.getPattern(store.getString("compileErrorPattern"));
        this.warnPattern = this.getPattern(store.getString("compileWarningPattern"));
        this.failPattern2 = this.getPattern(store.getString("compileFailPattern2"));
        this.errorPattern2 = this.getPattern(store.getString("compileErrorPattern2"));
        this.warnPattern2 = this.getPattern(store.getString("compileWarningPattern2"));
        this.isAddInfoMarker = store.getBoolean("isAddMarkerCompileInfo");
    }

    private Pattern getPattern(String value) {
        if (value == null || value.length() == 0) {
            return null;
        }
        return Pattern.compile(value);
    }

    protected void addMarker(String result, IProject project, String markerId) throws CoreException {
        boolean isWarningPattern;
        boolean isErrorPattern = false;
        isErrorPattern = this.addErrorMarker(this.errorPattern, result, project, markerId);
        if (!isErrorPattern) {
            isErrorPattern = this.addErrorMarker(this.errorPattern2, result, project, markerId);
        }
        if (!isErrorPattern) {
            isErrorPattern = this.addFailureMarker(this.failPattern, result, project, markerId);
        }
        if (!isErrorPattern) {
            isErrorPattern = this.addFailureMarker(this.failPattern2, result, project, markerId);
        }
        if (!(isWarningPattern = this.addWarningMarker(this.warnPattern, result, project, markerId))) {
            this.addWarningMarker(this.warnPattern2, result, project, markerId);
        }
        if (this.isAddInfoMarker) {
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            attributes.put("priority", 0);
            attributes.put("severity", 0);
            attributes.put("lineNumber", 0);
            attributes.put("message", result);
            MarkerUtilities.createMarker((IResource)this.getProject(), attributes, (String)markerId);
        }
    }

    private boolean addErrorMarker(Pattern pattern, String result, IProject project, String markerId) throws CoreException {
        if (pattern != null) {
            boolean isExists = false;
            Matcher matcher = pattern.matcher(result);
            while (matcher.find()) {
                if (matcher.groupCount() < 3) continue;
                String fileName = new File(matcher.group(1)).getName();
                this.addMarker(project.getFile(fileName), matcher.group(1), matcher.group(2), matcher.group(3), 2, markerId);
                isExists = true;
            }
            return isExists;
        }
        return false;
    }

    private boolean addFailureMarker(Pattern pattern, String result, IProject project, String markerId) throws CoreException {
        if (pattern != null) {
            Matcher matcher = pattern.matcher(result);
            boolean isExists = false;
            while (matcher.find()) {
                HashMap<String, Object> attributes = new HashMap<String, Object>();
                attributes.put("priority", 2);
                attributes.put("severity", 2);
                attributes.put("lineNumber", 0);
                attributes.put("message", matcher.group(1));
                MarkerUtilities.createMarker((IResource)this.getProject(), attributes, (String)markerId);
                isExists = true;
            }
            return isExists;
        }
        return false;
    }

    private boolean addWarningMarker(Pattern pattern, String result, IProject project, String markerId) throws CoreException {
        if (pattern != null) {
            Matcher matcher = pattern.matcher(result);
            boolean isExists = false;
            while (matcher.find()) {
                if (matcher.groupCount() < 3) continue;
                String fileName = new File(matcher.group(1)).getName();
                this.addMarker(project.getFile(fileName), matcher.group(1), matcher.group(2), matcher.group(3), 1, markerId);
                isExists = true;
            }
            return isExists;
        }
        return false;
    }

    protected FcshShell createFcshShell(IProject project, IProgressMonitor monitor) throws IOException, CoreException {
        FcshShell fcsh = fcshShells.get(project);
        monitor.worked(this.workd++);
        if (fcsh == null || fcsh.getProcess() == null) {
            fcsh = new FcshShell();
            this.clearCompiler(project);
            fcshShells.put(project, fcsh);
            fcsh.startShell(new File(project.getLocation().toString()), monitor);
            monitor.worked(this.workd++);
        }
        fcsh.setWorkdIndex(this.workd);
        return fcsh;
    }

    protected abstract void clearCompiler(IProject var1);

    private void addMarker(IFile compileFile, String fileName, String line, String message, int level, String markerId) throws CoreException {
        fileName = fileName.substring(compileFile.getParent().getLocation().toString().length() + 1);
        IFile errorFile = compileFile.getParent().getFile((IPath)new Path(fileName));
        IMarker marker = errorFile.createMarker(markerId);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("severity", new Integer(level));
        map.put("message", message);
        map.put("lineNumber", new Integer(line));
        marker.setAttributes(map);
    }

    private void addLifecycleListener() {
        if (this.getProject().getWorkspace() instanceof Workspace) {
            ILifecycleListener lifecycleListener = new ILifecycleListener(){

                public void handleEvent(LifecycleEvent event) throws CoreException {
                    if ((event.kind == 16 || event.kind == 1) && event.resource == AbstractAIRBuilder.this.getProject()) {
                        AirBuilderManager.shutdownCompiler(AbstractAIRBuilder.this.getProject());
                    }
                }
            };
            ((Workspace)this.getProject().getWorkspace()).addLifecycleListener(lifecycleListener);
        }
    }

    protected Pattern getMessagePattern() {
        return this.messagePattern;
    }
}

