/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amateras.air;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import net.sf.amateras.air.ComponentImageRegistry;
import net.sf.amateras.air.as.EditorColorProvider;
import net.sf.amateras.air.builder.AirBuilderManager;
import net.sf.amateras.air.util.ColorManager;
import net.sf.amateras.air.util.FontManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.ui.editors.text.templates.ContributionContextTypeRegistry;
import org.eclipse.ui.editors.text.templates.ContributionTemplateStore;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class AIRPlugin
extends AbstractUIPlugin {
    public static final String PREF_AIR_SDK_PATH = "airSdkPath";
    public static final String PREF_FLEX_SDK_PATH = "flexSdkPath";
    public static final String PREF_FLEX_LIBRARIES = "flexLibraries";
    public static final String PREF_FLEX_COMPILES = "flexCompiles";
    public static final String PREF_DESCRIPTOR_NAMESPACE = "flexDescriptorNamespace";
    public static final String PREF_FCSH_SHELL_COMMAND = "fcshShellCommand";
    public static final String PREF_ADL_COMMAND = "adlCommand";
    public static final String PREF_ADT_COMMAND = "adtCommand";
    public static final String PREF_FLEX_COMPILE_COMMAND = "flexCompileCommand";
    public static final String PREF_FLEX_COMPILE_OPTION = "flexCompileCommandOption";
    public static final String PREF_AS3_COMPILE_COMMAND = "as3CompileCommand";
    public static final String PREF_AS3_COMPILE_OPTION = "as3CompileCommandOption";
    public static final String PREF_COMPILE_MESSAGE_PATTERN = "compileMessagePattern";
    public static final String PREF_COMPILE_FAIL_PATTERN = "compileFailPattern";
    public static final String PREF_COMPILE_ERROR_PATTERN = "compileErrorPattern";
    public static final String PREF_COMPILE_WARNING_PATTERN = "compileWarningPattern";
    public static final String PREF_COMPILE_FAIL_PATTERN_2 = "compileFailPattern2";
    public static final String PREF_COMPILE_ERROR_PATTERN_2 = "compileErrorPattern2";
    public static final String PREF_COMPILE_WARNING_PATTERN_2 = "compileWarningPattern2";
    public static final String PREF_IS_ADD_MARKER_COMPILE_INFO = "isAddMarkerCompileInfo";
    public static final String PREF_EXPORT_STORE_TYPE = "exportStoreType";
    public static final String PREF_EXPORT_KEY_STORE = "exportKeyStore";
    public static final String PREF_EXPORT_STORE_PASS = "exportStorePass";
    public static final String PREF_EXPORT_PACKAGE_NAME = "exportPackageName";
    public static final String PREF_EXPORT_PACK_LIST = "exportPackList";
    public static final String PREF_DESCRIPTOR = "decriptor";
    public static final String PREF_COLOR_DEFAULT = "colorDefault";
    public static final String PREF_COLOR_COMMENT = "colorComment";
    public static final String PREF_COLOR_STRING = "colorString";
    public static final String PREF_COLOR_KEYWORD = "colorKeyword";
    public static final String PREF_FONT_MATTING_SIZE = "fontMattingSize";
    public static final String CONTEXT_AS3_TYPE_ID = "net.sf.amateras.air.templates.as3";
    public static final String CONTEXT_MXML_TYPE_ID = "net.sf.amateras.air.templates.mxml";
    public static final String CONTEXT_DESCRIPTOR_TYPE_ID = "net.sf.amateras.air.templates.descriptor";
    public static final String TEMPLATE_STORE_ID = "net.sf.amateras.air.templates.store";
    public static final String PLUGIN_ID = "net.sf.amateras.air";
    private static AIRPlugin plugin;
    private EditorColorProvider editorColorProvider;
    private ColorManager colorManager;
    private FontManager fontManager;
    private static final ResourceBundle RESOURCE_BUNDLE;
    private String nameSpacePrefix = "mx:";
    private ContributionTemplateStore as3TemplateStore = null;
    private ContributionTemplateStore mxmlTemplateStore = null;
    private ContributionTemplateStore descriptorTemplateStore = null;
    private ContributionContextTypeRegistry as3ContextRegistry = null;
    private ContributionContextTypeRegistry mxmlContextRegistry = null;
    private ContributionContextTypeRegistry descriptorContextRegistry = null;

    static {
        RESOURCE_BUNDLE = ResourceBundle.getBundle("airplugin");
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.editorColorProvider = new EditorColorProvider(this.getPreferenceStore());
        this.colorManager = new ColorManager();
        this.fontManager = new FontManager();
        plugin = this;
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        super.initializeImageRegistry(reg);
        ComponentImageRegistry.init();
        reg.put("SET_PROPERTY_IMAGE", AIRPlugin.getImageDescriptor("icons/set_property.gif"));
        reg.put("CONTENTS_ASSIST_CLASS", AIRPlugin.getImageDescriptor("icons/class.gif"));
        reg.put("CONTENTS_ASSIST_PROERTY", AIRPlugin.getImageDescriptor("icons/property.gif"));
        reg.put("CONTENTS_ASSIST_METHOD", AIRPlugin.getImageDescriptor("icons/method.gif"));
        reg.put("CONTENTS_ASSIST_INTERFACE", AIRPlugin.getImageDescriptor("icons/interface.gif"));
        reg.put("CONTENTS_ASSIST_RESERVED_WORD", AIRPlugin.getImageDescriptor("icons/reservedword.gif"));
        reg.put("CONTENTS_ASSIST_TEMPLATE", AIRPlugin.getImageDescriptor("icons/text.gif"));
        reg.put("SOURCE_FOLDER", AIRPlugin.getImageDescriptor("icons/sourcefolder.gif"));
        reg.put("SWC_JAR", AIRPlugin.getImageDescriptor("icons/swc.gif"));
    }

    public ColorManager getColorManager() {
        return this.colorManager;
    }

    public FontManager getFontManager() {
        return this.fontManager;
    }

    public EditorColorProvider getEditorColorProvider() {
        return this.editorColorProvider;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        this.editorColorProvider.dispose();
        this.colorManager.dispose();
        this.fontManager.dispose();
        AirBuilderManager.shutdownCompilers();
        ComponentImageRegistry.dispose();
        super.stop(context);
    }

    public static AIRPlugin getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public String getNameSpacePrefix() {
        return this.nameSpacePrefix;
    }

    public static void logException(Throwable ex) {
        ILog log = AIRPlugin.getDefault().getLog();
        Object status = null;
        status = ex instanceof CoreException ? ((CoreException)ex).getStatus() : new Status(4, PLUGIN_ID, 0, ex.toString(), ex);
        log.log(status);
        ex.printStackTrace();
    }

    public static void addNature(IProject project, String natureId) {
        try {
            IProjectDescription description = project.getDescription();
            String[] natures = description.getNatureIds();
            int i = 0;
            while (i < natures.length) {
                if (natures[i].equals(natureId)) {
                    return;
                }
                ++i;
            }
            String[] newNatures = new String[natures.length + 1];
            System.arraycopy(natures, 0, newNatures, 0, natures.length);
            newNatures[natures.length] = natureId;
            description.setNatureIds(newNatures);
            project.setDescription(description, null);
        }
        catch (Exception ex) {
            AIRPlugin.logException(ex);
        }
    }

    public static void removeNature(IProject project, String natureId) {
        try {
            IProjectDescription description = project.getDescription();
            String[] natures = description.getNatureIds();
            int i = 0;
            while (i < natures.length) {
                if (natureId.equals(natures[i])) {
                    String[] newNatures = new String[natures.length - 1];
                    System.arraycopy(natures, 0, newNatures, 0, i);
                    System.arraycopy(natures, i + 1, newNatures, i, natures.length - i - 1);
                    description.setNatureIds(newNatures);
                    project.setDescription(description, null);
                    return;
                }
                ++i;
            }
        }
        catch (Exception ex) {
            AIRPlugin.logException(ex);
        }
    }

    public static String getResourceString(String key) {
        return RESOURCE_BUNDLE.getString(key);
    }

    public static String getResourceString(String key, Object ... args) {
        String value = RESOURCE_BUNDLE.getString(key);
        return MessageFormat.format(value, args);
    }

    public static ResourceBundle getResourceBundle() {
        return RESOURCE_BUNDLE;
    }

    public TemplateStore getTemplateAS3Store() {
        if (this.as3TemplateStore == null) {
            this.as3TemplateStore = new ContributionTemplateStore(this.getCotextAS3TypeRegistry(), this.getPreferenceStore(), TEMPLATE_STORE_ID);
            try {
                this.as3TemplateStore.load();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return this.as3TemplateStore;
    }

    public TemplateStore getTemplateMXMLStore() {
        if (this.mxmlTemplateStore == null) {
            this.mxmlTemplateStore = new ContributionTemplateStore(this.getCotextMXMLTypeRegistry(), this.getPreferenceStore(), TEMPLATE_STORE_ID);
            try {
                this.mxmlTemplateStore.load();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return this.mxmlTemplateStore;
    }

    public TemplateStore getTemplateDescriptorStore() {
        if (this.descriptorTemplateStore == null) {
            this.descriptorTemplateStore = new ContributionTemplateStore(this.getCotextDescriptorTypeRegistry(), this.getPreferenceStore(), TEMPLATE_STORE_ID);
            try {
                this.descriptorTemplateStore.load();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return this.descriptorTemplateStore;
    }

    public ContextTypeRegistry getCotextAS3TypeRegistry() {
        if (this.as3ContextRegistry == null) {
            this.as3ContextRegistry = new ContributionContextTypeRegistry();
            this.as3ContextRegistry.addContextType(CONTEXT_AS3_TYPE_ID);
        }
        return this.as3ContextRegistry;
    }

    public ContextTypeRegistry getCotextMXMLTypeRegistry() {
        if (this.mxmlContextRegistry == null) {
            this.mxmlContextRegistry = new ContributionContextTypeRegistry();
            this.mxmlContextRegistry.addContextType(CONTEXT_MXML_TYPE_ID);
        }
        return this.mxmlContextRegistry;
    }

    public ContextTypeRegistry getCotextDescriptorTypeRegistry() {
        if (this.descriptorContextRegistry == null) {
            this.descriptorContextRegistry = new ContributionContextTypeRegistry();
            this.descriptorContextRegistry.addContextType(CONTEXT_DESCRIPTOR_TYPE_ID);
        }
        return this.descriptorContextRegistry;
    }
}

