package tk.ipmsg.swt;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.MessageBox;

/**
 * ڑ͂_CAOB
 * 
 * @author Naoki Takezoe
 */
public class SetupDialog {
    
    private Shell   shell;
    private Display display;
    private Text    userName;
    private Text    groupName;
    private Button  button;
    private String  user;
    private String  group;
    private boolean returnFlag = false;
    
	/**
	 * Constructor for SetupDialog.
	 * @param arg0
	 */
	public SetupDialog(Shell shell) {
        this.shell = new Shell(shell,SWT.TITLE|SWT.MIN|SWT.CLOSE);
        initComponents();
	}
    
    /**
     * R|[lg̏
     */
    private void initComponents(){
        
        shell.setText("OC");
        
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        shell.setLayout(layout);

        Label label1 = new Label(shell,SWT.NULL);
        label1.setText("[U");
        this.userName = new Text(shell,SWT.BORDER);
        this.userName.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
        
        Label label2 = new Label(shell,SWT.NULL);
        label2.setText("O[v");
        this.groupName = new Text(shell,SWT.BORDER);
        this.groupName.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
        
        GridData gridData = new GridData(GridData.HORIZONTAL_ALIGN_END);     
        gridData.horizontalSpan = 2;
        
        this.button = new Button(shell,SWT.NULL);
        this.button.setText("OC");
        this.button.addSelectionListener(new LoginListener());
        this.button.setLayoutData(gridData);
        
        userName.setFocus();
        shell.setDefaultButton(button);
        shell.pack();
        Point point = shell.getSize();
        point.x = 200;
        shell.setSize(point);
        
    }
    
    /**
     * _CAȌlݒ肵܂B
     * 
     * @param userName  [U
     * @param groupName O[v
     */
    public void setInitValue(String userName,String groupName){
        if(userName!=null){
            this.userName.setText(userName);
        }
        if(groupName!=null){
            this.groupName.setText(groupName);
        }
    }
    
    /**
     * _CAOJ܂B
     */
    public boolean open(){
        
        this.returnFlag = false;
        
        Display display = this.shell.getDisplay();
        this.shell.open();
        
        // ubN
        while (!this.shell.isDisposed ()){
            if (!display.readAndDispatch ()){
                display.sleep ();
            }
        }
        
        return returnFlag;
    }
    
    /**
     * ͂ꂽ[U擾܂B
     */
    public String getUserName(){
        return this.user;
    }
    
    /**
     * ͂ꂽO[v擾܂B
     */
    public String getGroupName(){
        return this.group;
    }
    
    /**
     * OC{^̏
     */
    class LoginListener extends SelectionAdapter {

        public void widgetSelected(SelectionEvent e){
            // ̓`FbN
            if(userName.getText()==null || userName.getText().equals("")){
                MessageBox mesBox = new MessageBox(shell,SWT.OK);
                mesBox.setText("G[");
                mesBox.setMessage("[U͂Ă");
                mesBox.open();
                userName.setFocus();
                return;
            }
            
            returnFlag = true;
            user  = userName.getText();
            group = groupName.getText();
            shell.dispose();
        }

    }

    
}
