package tk.ipmsg.swt;

import java.io.IOException;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

/**
 * bZ[WԐM邽߂̃_CAOB
 */
public class SendDialog {
    
    private Shell shell;
    
    private String message;
    private String host;
    private String user;
    
    private Text text;
    private Button send;
    private Button lock;
    private Messenger messenger;
    
	/**
	 * Constructor for SendDialog.
	 */
	public SendDialog(Shell shell,String host,String user,String message,Messenger messenger) {
		this.shell = new Shell(shell,SWT.TITLE|SWT.RESIZE|SWT.MIN|SWT.CLOSE);
        this.message = message;
        this.host = host;
        this.messenger = messenger;
        this.user = user;
        
        initComponents();
	}
    
    /**
     * R|[lg̏
     */
    private void initComponents(){
        shell.setText(user + "ւ̕ԐM");
        
        GridLayout layout = new GridLayout();
        shell.setLayout(layout);
        
        text = new Text(shell,SWT.V_SCROLL|SWT.WRAP|SWT.MULTI|SWT.BORDER);
        GridData gridData1 = new GridData(GridData.FILL_BOTH);
        text.setLayoutData(gridData1);
        String res = createResponseMessage(message);
        text.setText(res);
        text.setSelection(res.length());
        
        Composite composite = new Composite(shell,SWT.NULL);
        GridData gridData2 = new GridData(GridData.HORIZONTAL_ALIGN_END);
        composite.setLayoutData(gridData2);
        RowLayout layout2 = new RowLayout();
        composite.setLayout(layout2);
        
        send = new Button(composite,SWT.NULL);
        send.setText("      M      ");
        send.addSelectionListener(new SendListener());
        
        lock = new Button(composite,SWT.CHECK);
        lock.setText("");
        
        shell.setSize(300,200);
    }
    
    /**
     * _CAO\܂B
     */
    public void open(){
        shell.open();
        
        // ubN
        while (!shell.isDisposed()){
            if (!shell.getDisplay().readAndDispatch ()){
                shell.getDisplay().sleep ();
            }
        }
    }
    
    /**
     * ԐMp̃bZ[W쐬܂B
     */
    private static String createResponseMessage(String source){
        
        if(source==null || source.equals("")){
            return "";
        }
        
        StringBuffer sb = new StringBuffer();
        sb.append("> ");
        for(int i=0;i<source.length();i++){
            char c = source.charAt(i);
            if(c=='\n'){
                sb.append(c);
                sb.append("> ");
            } else {
                sb.append(c);
            }
        }
        //sb.append("\n\n");
        return sb.toString();
    }
    
    /**
     * M{^̏
     */
    class SendListener extends SelectionAdapter {
        public void widgetSelected(SelectionEvent e){
            String msg = text.getText();
            if(msg!=null && !msg.equals("")){
                try {
                    messenger.sendMsg(user,host,msg,lock.getSelection());
                } catch(IOException ex){
                    // O
                    ex.printStackTrace();
                    MessageBox mesBox = new MessageBox(shell,SWT.OK|SWT.ICON_ERROR);
                    mesBox.setText("O");
                    mesBox.setMessage(ex.toString());
                    mesBox.open();
                }
            }
            shell.dispose();
        }
    }
    
}
