package tk.ipmsg.swt;

import java.io.IOException;
import java.util.Date;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.MessageBox;

/**
 * M_CAOB
 * 
 * @author Naoki Takezoe
 */
public class ReceiveDialog {
    
    private Button open;
    private Text   text;
    private Shell  shell;
    private Composite composite;
    private Button response;
    private Button close;
    
    private String userName;
    //private String groupName;
    private String host;
    private String message;
    private boolean lock;
    private String date;
    private Messenger messenger;
    
	/**
	 * Constructor for ReceiveDialog.
	 * @param arg0
	 */
	public ReceiveDialog(Shell shell,String userName,String host,
                         String message,boolean lock,Messenger messenger) {
        this.shell = new Shell(shell,SWT.TITLE|SWT.RESIZE|SWT.MIN|SWT.CLOSE);
        this.userName  = userName;
        //this.groupName = groupName;
        this.host      = host;
        this.message   = message;
        this.lock      = lock;
        this.date      = new Date().toString();
        this.messenger = messenger;
        initComponents();
	}
    
    /**
     * R|[lg̏
     */
    private void initComponents(){
        this.shell.setText("MbZ[W");
        GridLayout layout = new GridLayout();
        this.shell.setLayout(layout);
        
        Label label = new Label(shell,SWT.CENTER);
        label.setText(userName+"("+host+")\n"+date);
        GridData gridData1 = new GridData(GridData.FILL_HORIZONTAL);
        label.setLayoutData(gridData1);
        
        composite = new Composite(shell,SWT.NULL);
        composite.setLayoutData(new GridData(GridData.FILL_BOTH));
        composite.setLayout(new GridLayout());
        
        if(lock){
            this.open = new Button(composite,SWT.NULL);
            this.open.setText("J");
            GridData gridData2 = new GridData(GridData.FILL_BOTH);
            this.open.setLayoutData(gridData2);
            this.open.addSelectionListener(new OpenListener());
            this.shell.setDefaultButton(this.open);
        } else {
            this.text = new Text(composite,SWT.WRAP|SWT.MULTI|SWT.V_SCROLL|SWT.READ_ONLY|SWT.BORDER);
            this.text.setText(message);
            GridData gridData3 = new GridData(GridData.FILL_BOTH);
            this.text.setLayoutData(gridData3);
        }
        
        Composite buttons = new Composite(shell,SWT.NULL);
        buttons.setLayout(new RowLayout());
        buttons.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_CENTER));
        
        close = new Button(buttons,SWT.NULL);
        close.setText("  ");
        close.addSelectionListener(new CloseListener());
        
        response = new Button(buttons,SWT.NULL);
        response.setText("  M ");
        response.addSelectionListener(new ResponseListener());
        
        shell.setSize(300,200);
    }
    
    /**
     * J̏
     */
    class OpenListener extends SelectionAdapter {
        public void widgetSelected(SelectionEvent e){
            open.dispose();
            text = new Text(composite,SWT.MULTI|SWT.V_SCROLL|SWT.READ_ONLY|SWT.BORDER);
            text.setText(message);
            GridData gridData3 = new GridData(GridData.FILL_BOTH);
            text.setLayoutData(gridData3);
            composite.layout();
            
            // Jʒm
            try {
                messenger.readMsg(host);
            } catch(IOException ex){
                // O
                ex.printStackTrace();
                MessageBox mesBox = new MessageBox(shell,SWT.OK|SWT.ICON_ERROR);
                mesBox.setText("O");
                mesBox.setMessage(ex.toString());
                mesBox.open();
            }
        }
    }
    
    /**
     * {^̏
     */
    class CloseListener extends SelectionAdapter {
        public void widgetSelected(SelectionEvent e){
            shell.dispose();
        }
    }
    
    /**
     * ԐM{^̏
     */
    class ResponseListener extends SelectionAdapter {
        public void widgetSelected(SelectionEvent e){
            String msg = message;
            if(lock && text==null){
                msg = "";
            }
            SendDialog dialog = new SendDialog(shell,host,userName,msg,messenger);
            dialog.open();
        }
    }
    
    /**
     * _CAO\܂B
     */
    public void open(){
        Display display = this.shell.getDisplay();
        this.shell.open();
        
        // ubN
        while (!this.shell.isDisposed ()){
            if (!display.readAndDispatch ()){
                display.sleep ();
            }
        }
    }
    
    /**
     * eXgpN\bh
     */
    public static void main(String[] args){
        Display display = new Display();
        Shell shell = new Shell(display);
        ReceiveDialog dialog = new ReceiveDialog(shell,"takezoe","TMS2","test",true,null);
        dialog.open();
    }

}
