package tk.ipmsg.swt;

import java.io.IOException;
import java.util.Date;
import java.util.HashMap;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.MessageBox;
import tk.ipmsg.IPMessenger;

/**
 * SWTIPMessenger̃obNGhœ삷T[oXbhB
 * 
 * @author Naoki Takezoe
 */
public class Messenger extends IPMessenger {
    
    private Main main;
    private HashMap hash = new HashMap();
    
	/**
	 * Constructor for Messenger.
	 * 
	 * @param userName
	 * @param nickName
	 * @param group
	 * @throws IOException
	 */
	public Messenger(String userName, String nickName, String group,Main main) throws IOException {
		super(userName, nickName, group, main.getDebugMode());
        this.main = main;
	}

	public void receiveMsg(String host, String user, String msg, boolean flag) {
		// _CAO\
        main.getShell().getDisplay().asyncExec(new RunnableReceiveMessage(host,user,msg,flag,this));
        // Oo
        StringBuffer sb = new StringBuffer();
        sb.append("=====================================\n");
        sb.append("From:" + user + "(" + host + ")\n");
        sb.append(new Date().toString() + "\n");
        sb.append("-------------------------------------\n");
        sb.append(msg + "\n\n");
        Logger.writeLog(sb.toString());
	}
    
    public void openMsg(String host,String user){
        main.getShell().getDisplay().asyncExec(new RunnableOpenMessage(host,user));
    }
    
	public void addMember(String host,String nickName,String group,String addr,int absence) {
        if(hash.get(host)==null){
            main.getShell().getDisplay().asyncExec(new RunnableAddMember(nickName,group,host));
            hash.put(host,nickName);
        }
	}

	public void sendMsg(String user, String host, String msg, boolean secret) throws IOException {
		// M
		super.sendMsg(host, msg, secret);
		// Oo
        StringBuffer sb = new StringBuffer();
        sb.append("=====================================\n");
        sb.append("To:" + user + "(" + host + ")\n");
        sb.append(new Date().toString() + "\n");
        sb.append("-------------------------------------\n");
        sb.append(msg + "\n\n");
        Logger.writeLog(sb.toString());
	}
	
	public void removeMember(String host) {
        if(hash.get(host)!=null && !main.getShell().isDisposed()){
            main.getShell().getDisplay().asyncExec(new RunnableRemoveMember(host));
            hash.remove(host);
        }
	}
    
    /**
     * o[ǉXbh
     */
    class RunnableAddMember implements Runnable {
        
        private String nickName;
        private String group;
        private String host;
        
        public RunnableAddMember(String nickName,String group,String host){
            this.nickName = nickName;
            this.group    = group;
            this.host     = host;
        }
        
        public void run(){
            main.addMember(nickName,group,host);
        }
    }
    
    /**
     * o[폜Xbh
     */
    class RunnableRemoveMember implements Runnable {
        
        private String host;
        
        public RunnableRemoveMember(String host){
            this.host = host;
        }
        
        public void run(){
            main.removeMember(host);
        }
        
    }
    
    /**
     * bZ[WMă_CAO\Xbh
     */
    class RunnableReceiveMessage implements Runnable {
        
        private String    user;
        private String    host;
        private String    message;
        private boolean   flag;
        private Messenger messenger;
        
        public RunnableReceiveMessage(String host,String user,String message,boolean flag,Messenger messenger){
            this.host      = host;
            this.user      = user;
            this.message   = message;
            this.flag      = flag;
            this.messenger = messenger;
        }
        
        public void run(){
            ReceiveDialog dialog = new ReceiveDialog(main.getShell(),user,host,message,flag,messenger);
            dialog.open();
        }
    }
    
    /**
     * Jʒm_CAO\XbhB
     */
    class RunnableOpenMessage implements Runnable {
        
        private String host;
        private String user;
        
        public RunnableOpenMessage(String host,String user){
            this.host = host;
            this.user = user;
        }
        
        public void run(){
            MessageBox dialog = new MessageBox(main.getShell(),SWT.OK);
            dialog.setText(this.user);
            dialog.setMessage("J܂\n("+new Date().toString()+")");
            dialog.open();
        }
    }

}
